//? if fabric {
package dev.imb11.sounds.loaders.fabric;

import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.dynamic.SoundsReloadListener;
import dev.imb11.sounds.sound.events.PotionEventHelper;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class SoundsFabric implements ClientModInitializer {
    private final PotionEventHelper potionEventHelper = new PotionEventHelper();

    @Override
    public void onInitializeClient() {
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SoundsReloadListenerFabric());
        SoundsClient.init();

        ClientTickEvents.START_WORLD_TICK.register(potionEventHelper::listenForEffectChanges);
    }

    public static class SoundsReloadListenerFabric extends SoundsReloadListener implements IdentifiableResourceReloadListener  {
        @Override
        public class_2960 getFabricId() {
            return SoundsClient.id("reload_listener");
        }

        @Override
        public void reload(class_3300 manager) {
            super.reload(manager);
        }
    }
}
//?}
