package dev.imb11.sounds.mixin.ui;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Set;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_465;

@Mixin(class_465.class)
public class ItemDragSoundEffect<T extends class_1703> {
    @Shadow
    @Final
    protected Set<class_1735> quickCraftSlots;

    @Shadow
    @Final
    protected T menu;

    @Inject(method = "mouseDragged", at = @At(value = "INVOKE", target = "Ljava/util/Set;add(Ljava/lang/Object;)Z"), locals = LocalCapture.CAPTURE_FAILSOFT)
    private void $item_drag_sound_effect(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir, class_1735 slot) {
        if (!quickCraftSlots.contains(slot) && quickCraftSlots.size() > 0)
            SoundsConfig.get(UISoundsConfig.class).itemDragSoundEffect.playDynamicSound(this.menu.method_34255(), ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
    }
}
