package dev.imb11.sounds.mixin.ui;

import dev.imb11.sounds.util.MixinStatics;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(class_1657.class)
abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At("HEAD"))
    protected void $drop_item_sound_effect(
            class_1799 stack,
            boolean throwRandomly,
            boolean retainOwnership,
            CallbackInfoReturnable<class_1542> cir) {
    }
}

@Pseudo
@Mixin(class_746.class)
public abstract class ItemDropSoundEffect extends PlayerEntityMixin {
    @Shadow @Final protected class_310 minecraft;

    @Shadow public abstract void method_5783(@NotNull class_3414 sound, float volume, float pitch);

    protected ItemDropSoundEffect(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Unique
    private static long sounds$dropSoundCooldownTime = 0L;

    @Unique
    private void sounds$playSound(class_1799 stack) {
        if(MixinStatics.hasOpenedInventorioScreen) {
            sounds$dropSoundCooldownTime = System.currentTimeMillis() + ((long) SoundsConfig.get(UISoundsConfig.class).itemSoundCooldown);
            MixinStatics.hasOpenedInventorioScreen = false;
            return;
        }
        if(sounds$dropSoundCooldownTime > System.currentTimeMillis()) return;
        sounds$dropSoundCooldownTime = System.currentTimeMillis() + ((long) SoundsConfig.get(UISoundsConfig.class).itemSoundCooldown);

        if (MixinStatics.previousAction == class_1713.field_7794) {
            MixinStatics.previousAction = null;
            return;
        }

        SoundsConfig.get(UISoundsConfig.class).itemDropSoundEffect.playDynamicSound(stack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.FALL));
    }

    @Inject(method = "drop", at = @At("HEAD"))
    private void $drop_selected_item_sound_effect(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        class_1799 stack = this.method_6047();
        sounds$playSound(stack);
    }

    @Override
    protected void $drop_item_sound_effect(
            class_1799 stack,
            boolean throwRandomly,
            boolean retainOwnership,
            CallbackInfoReturnable<class_1542> cir) {
        if (!this.method_37908().field_9236) return;
        sounds$playSound(stack);
    }
}
