package dev.imb11.sounds.mixin.world.mechanics;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public class SwordSwingSoundEffect {
    @Shadow
    public int swingTime;
    @Unique
    public class_1113 sounds$currentSwordSwooshSound;
    @Unique
    private static long lastPlayed = 0;
    @Unique
    private static final long COOLDOWN = 250;

    @Inject(method = "swing(Lnet/minecraft/world/InteractionHand;Z)V", at = @At(value = "HEAD"))
    public void $start_sword_swoosh_sound(class_1268 interactionHand, boolean bl, CallbackInfo ci) {
        long currentTime = System.currentTimeMillis();
        var entity =  (class_1309) (Object) this;
        if (!entity.method_37908().method_8608()) return;
        if (entity instanceof class_746 localPlayer && localPlayer.equals(class_310.method_1551().field_1724)) {
            if (entity.method_5998(interactionHand).method_31573(class_3489.field_42611) && (currentTime - lastPlayed > COOLDOWN)) {
                this.sounds$currentSwordSwooshSound = SoundsConfig.get(WorldSoundsConfig.class).swordSwooshSoundEffect.getSoundInstance();
                if (this.sounds$currentSwordSwooshSound != null) {
                    SoundsConfig.get(WorldSoundsConfig.class).swordSwooshSoundEffect.playSound(this.sounds$currentSwordSwooshSound);
                    lastPlayed = currentTime;
                }
            }
        }
    }

}
