package dev.imb11.sounds.sound.context;

import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.mixin.accessors.BlockAccessor;
import net.minecraft.class_1113;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ItemStackSoundContext implements DynamicSoundContext<class_1799> {
    private final DynamicSoundHelper.BlockSoundType blockSoundType;

    public ItemStackSoundContext() {
        this(DynamicSoundHelper.BlockSoundType.FALL);
    }

    public ItemStackSoundContext(DynamicSoundHelper.BlockSoundType blockSoundType) {
        this.blockSoundType = blockSoundType;
    }

    public static ItemStackSoundContext of(DynamicSoundHelper.BlockSoundType blockSoundType) {
        return new ItemStackSoundContext(blockSoundType);
    }

    @Override
    public class_1113 handleContext(class_1799 context, class_2960 fallback, float pitch, float volume) {
        var item = context.method_7909();

        if (item instanceof class_1747 blockItem) {
            var block = blockItem.method_7711();
            fallback = this.blockSoundType.getTransformer().apply(((BlockAccessor)block).invokeGetSoundType(block.method_9564()));
        }

        for (SoundDefinition<class_1792> definition : DynamicSoundHelper.<class_1792>getDefinitions("items")) {
            if (definition.getKeys().isValid(item)) {
                fallback = definition.getSoundEvent();

                if (definition.getPitch().isPresent()) {
                    pitch = definition.getPitch().get();
                }

                if (definition.getVolume().isPresent()) {
                    volume = definition.getVolume().get();
                }

                break;
            }
        }

        return createSoundInstance(fallback, pitch, volume);
    }
}
