package dev.imb11.sounds.api;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class TagList<T> {

    private final List<Either<class_5321<T>, class_6862<T>>> _list;

    public TagList(List<Either<class_5321<T>, class_6862<T>>> list) {
        _list = list;
    }

    public static <T> Codec<TagList<T>> getCodec(class_5321<? extends class_2378<T>> registryKey) {
        return Codec.list(
                Codec.either(
                        class_5321.method_39154(registryKey),
                        class_6862.method_40093(registryKey)
                )
        ).xmap(TagList::new, TagList::getInternalList);
    }

    public List<Either<class_5321<T>, class_6862<T>>> getInternalList() {
        return _list;
    }

    public void add(Either<class_5321<T>, class_6862<T>> either) {
        _list.add(either);

        _list.sort((o1, o2) -> {
            // Sort alphabetically, tagkeys first then registrykeys
            if (o1.left().isPresent() && o2.right().isPresent()) {
                return -1;
            } else if (o1.right().isPresent() && o2.left().isPresent()) {
                return 1;
            } else if (o1.left().isPresent() && o2.left().isPresent()) {
                return o1.left().get().method_29177().method_12833(o2.left().get().method_29177());
            } else {
                return o1.right().get().comp_327().method_12833(o2.right().get().comp_327());
            }
        });
    }

    public boolean isValid(T value) {
        for (Either<class_5321<T>, class_6862<T>> either : _list) {
            if (either.left().isPresent()) {
                var key = either.left().get();
                class_2378<T> registry = (class_2378<T>) class_7923.field_41167.method_10223(key.method_41185());
                assert registry != null;
                var entry = registry.method_10221(value);
                if (either.left().get().method_29177().equals(entry)) {
                    return true;
                }
            } else if (either.right().isPresent()) {
                class_6862<T> tagKey = either.right().get();
                class_2378<T> registry = (class_2378<T>) class_7923.field_41167.method_10223(tagKey.comp_326().method_29177());
                assert registry != null;
                var entry = registry.method_47983(value);
                if (entry.method_40220(tagKey)) {
                    return true;
                }
            }
        }
        return false;
    }
}
