package dev.imb11.sounds.api.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;

public class DynamicConfiguredSound<T, F extends DynamicSoundContext<T>> extends ConfiguredSound {
    public static final Codec<DynamicConfiguredSound> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    Codec.STRING.fieldOf("id").forGetter(ConfiguredSound::getId),
                    class_2960.field_25139.fieldOf("soundEvent").forGetter(sound -> sound.soundEvent),
                    Codec.BOOL.fieldOf("shouldPlay").forGetter(ConfiguredSound::shouldPlay),
                    Codec.FLOAT.fieldOf("pitch").forGetter(ConfiguredSound::getPitch),
                    Codec.FLOAT.fieldOf("volume").forGetter(ConfiguredSound::getVolume),
                    Codec.BOOL.fieldOf("enabledDynamic").forGetter(DynamicConfiguredSound::canUseDynamicSounds)
            ).apply(instance, DynamicConfiguredSound::new));
    public boolean enableDynamicSounds;

    public DynamicConfiguredSound(String id, class_2960 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public DynamicConfiguredSound(String id, class_3414 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public DynamicConfiguredSound(String id, class_6880.class_6883<class_3414> soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public boolean canUseDynamicSounds() {
        return enableDynamicSounds;
    }

    public void playDynamicSound(class_3414 event) {
        playSound(class_1109.method_4757(event, this.pitch, this.volume));
    }

    public void playDynamicSound(T context, F contextHandler) {
        class_1113 event = contextHandler.handleContext(context, getSoundEvent(), this.pitch, this.volume);

        if (event == null || !enableDynamicSounds) {
            this.playSound();
            return;
        }

        this.playSound(event);
    }

    @Override
    public <E extends ConfiguredSound> ArrayList<Option<?>> addExtraOptions(E defaults) {
        DynamicConfiguredSound<?, ?> dynamicDefaults = (DynamicConfiguredSound<?, ?>) defaults;
        ArrayList<Option<?>> options = super.addExtraOptions(defaults);

        var shouldDynamic = Option.<Boolean>createBuilder()
                .name(class_2561.method_43471("sounds.config.dynamic.option"))
                .description(OptionDescription.createBuilder()
                                .text(class_2561.method_43471("sounds.config.dynamic.option.description")).build())
                .binding(dynamicDefaults.enableDynamicSounds, () -> this.enableDynamicSounds, (val) -> this.enableDynamicSounds = val)
                .controller(opt -> BooleanControllerBuilder.create(opt).coloured(true).onOffFormatter())
                .build();

        options.add(shouldDynamic);

        return options;
    }
}
