package dev.imb11.sounds.api.config;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import dev.imb11.sounds.dynamic.TagPairHelper;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class TagPair {
    private static final Codec<class_2498> BLOCK_GROUP_CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    Codec.FLOAT.fieldOf("pitch").forGetter(class_2498::method_10599),
                    Codec.FLOAT.fieldOf("volume").forGetter(class_2498::method_10597),
                    class_3414.field_41698.fieldOf("break").forGetter(class_2498::method_10595),
                    class_3414.field_41698.fieldOf("step").forGetter(class_2498::method_10594),
                    class_3414.field_41698.fieldOf("place").forGetter(class_2498::method_10598),
                    class_3414.field_41698.fieldOf("hit").forGetter(class_2498::method_10596),
                    class_3414.field_41698.fieldOf("fall").forGetter(class_2498::method_10593)
            ).apply(instance, class_2498::new));
    public static final Codec<TagPair> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    TagList.getCodec(class_7923.field_41175.method_30517()).fieldOf("keys").forGetter(TagPair::getKeys),
                    BLOCK_GROUP_CODEC.fieldOf("group").forGetter(TagPair::getGroup),
                    Codec.BOOL.fieldOf("enabled").forGetter(TagPair::isEnabled)
            ).apply(instance, TagPair::new));
    private final TagList<class_2248> keys;
    private final class_2498 group;
    private boolean enabled;

    public TagList<class_2248> getKeys() {
        return keys;
    }

    public class_2498 getGroup() {
        return group;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public TagPair(TagList<class_2248> keys, class_2498 group) {
        this.keys = keys;
        this.group = group;
        this.enabled = true;
    }

    public TagPair(TagList<class_2248> keys, class_2498 group, boolean enabled) {
        this(keys, group);
        this.enabled = enabled;
    }

    public static class Builder {
        private final TagList<class_2248> keys = new TagList<>(new ArrayList<>());;
        private class_2498 group;
        private boolean enabled;

        private Builder() {
            this.group = class_2498.field_11544;
            this.enabled = true;
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder group(float pitch, float volume, class_3414 breakSound, class_3414 stepSound, class_3414 placeSound, class_3414 hitSound, class_3414 fallSound) {
            this.group = new class_2498(pitch, volume, breakSound, stepSound, placeSound, hitSound, fallSound);
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(class_2248... keys) {
            for (class_2248 key : keys) {
                addKey(key);
            }
            return this;
        }

        public Builder addKey(class_2248 key) {
            keys.add(Either.left(class_7923.field_41175.method_29113(key).orElseThrow(() -> new RuntimeException("TagPair.Builder: Could not find RegistryKey for " + key.toString()))));
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(class_6862<class_2248>... keys) {
            for (class_6862<class_2248> key : keys) {
                addKey(key);
            }
            return this;
        }

        public Builder addKey(class_6862<class_2248> key) {
            keys.add(Either.right(key));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TagPair build() {
            return new TagPair(keys, group, enabled);
        }
    }
}
