package dev.imb11.sounds.dynamic;

import com.mojang.serialization.Codec;
import dev.imb11.mru.RegistryUtils;
import dev.imb11.sounds.api.SoundDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class DynamicSoundHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSoundHelper.class);
    protected static HashMap<String, Codec<?>> loadDirectories = new HashMap<>();
    protected static HashMap<String, ArrayList<?>> loadedDefinitions = new HashMap<>();

    protected static void declareDefinitionsToLoad(String directory, Codec<?> codec) {
        loadDirectories.put(directory, codec);
        loadedDefinitions.put(directory, new ArrayList<>());
    }

    protected static void clearDefinitions() {
        loadedDefinitions.values().forEach(ArrayList::clear);
    }

    public static void initialize() {
        declareDefinitionsToLoad("items", SoundDefinition.getCodec(class_7923.field_41178.method_30517()));
        declareDefinitionsToLoad("screens", SoundDefinition.getCodec(class_7923.field_41187.method_30517()));
    }

    public static <T> ArrayList<SoundDefinition<T>> getDefinitions(String directory) {
        return (ArrayList<SoundDefinition<T>>) loadedDefinitions.get(directory);
    }

    public enum BlockSoundType {
        PLACE(t -> RegistryUtils.getId(t.method_10598())),
        HIT(t -> RegistryUtils.getId(t.method_10596())),
        BREAK(t -> RegistryUtils.getId(t.method_10595())),
        FALL(t -> RegistryUtils.getId(t.method_10593())),
        STEP(t -> RegistryUtils.getId(t.method_10594()));

        private final Function<class_2498, class_2960> transformer;

        BlockSoundType(Function<class_2498, class_2960> transformer) {
            this.transformer = transformer;
        }

        public Function<class_2498, class_2960> getTransformer() {
            return transformer;
        }
    }
}
