/*? if >=1.21 && fabric {*/
package dev.imb11.sounds.loaders.fabric.datagen;

import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.datagen.SoundDefinitionProvider;
import dev.imb11.sounds.sound.CustomSounds;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class DynamicItemSounds extends SoundDefinitionProvider<class_1792> {
    protected DynamicItemSounds(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(dataOutput, registriesFuture, "items", class_7923.field_41178);
    }

    @Override
    public void accept(BiConsumer<String, SoundDefinition.Builder<class_1792>> provider) {
        provider.accept("anvils", create(class_3417.field_14727)
                .addKey(class_1802.field_8782)
                .addKey(class_1802.field_8750)
                .addKey(class_1802.field_8427));

        provider.accept("arrows", create(class_3417.field_15151)
                .addKey(class_3489.field_18317)
                .setPitch(0.7f)
                .setVolume(0.3f));

        provider.accept("trial_keys", create(class_3417.field_50100)
                .addKey(class_1802.field_47315)
                .addKey(class_1802.field_50139)
                .setPitch(1f)
                .setVolume(0.4f));

        provider.accept("wind_charge", create(class_3417.field_49049)
                .addKey(class_1802.field_49098)
                .setPitch(2f)
                .setVolume(0.1f));

        provider.accept("wooden_equipment", create(class_3417.field_14675)
                .addKey(class_1802.field_8406)
                .addKey(class_1802.field_8167)
                .addKey(class_1802.field_8647)
                .addKey(class_1802.field_8876)
                .addKey(class_1802.field_8091)
                .addKey(class_1802.field_8184)
                .addKey(class_1802.field_8600)
                .addKey(class_1802.field_23254)
                .addKey(class_1802.field_8688));

        provider.accept("stone_equipment", create(class_3417.field_14883)
                .addKey(class_1802.field_8062)
                .addKey(class_1802.field_8431)
                .addKey(class_1802.field_8387)
                .addKey(class_1802.field_8776)
                .addKey(class_1802.field_8528));

        provider.accept("chainmail_equipment", create(class_3417.field_15191)
                .addKey(class_1802.field_8283)
                .addKey(class_1802.field_8873)
                .addKey(class_1802.field_8218)
                .addKey(class_1802.field_8313));

        provider.accept("iron_equipment", create(class_3417.field_14862)
                .addKey(class_1802.field_8868)
                .addKey(class_1802.field_8255)
                .addKey(class_1802.field_8475)
                .addKey(class_1802.field_8609)
                .addKey(class_1802.field_8403)
                .addKey(class_1802.field_8699)
                .addKey(class_1802.field_8371)
                .addKey(class_1802.field_8578)
                .addKey(class_1802.field_8743)
                .addKey(class_1802.field_8523)
                .addKey(class_1802.field_8396)
                .addKey(class_1802.field_8660));

        provider.accept("golden_equipment", create(class_3417.field_14761)
                .addKey(class_1802.field_8825)
                .addKey(class_1802.field_8303)
                .addKey(class_1802.field_8335)
                .addKey(class_1802.field_8322)
                .addKey(class_1802.field_8845)
                .addKey(class_1802.field_8557)
                .addKey(class_1802.field_8560)
                .addKey(class_1802.field_8862)
                .addKey(class_1802.field_8678)
                .addKey(class_1802.field_8416)
                .addKey(class_1802.field_8753));

        provider.accept("diamond_equipment", create(class_3417.field_15103)
                .addKey(class_1802.field_8556)
                .addKey(class_1802.field_8527)
                .addKey(class_1802.field_8377)
                .addKey(class_1802.field_8250)
                .addKey(class_1802.field_8802)
                .addKey(class_1802.field_8807)
                .addKey(class_1802.field_8805)
                .addKey(class_1802.field_8058)
                .addKey(class_1802.field_8348)
                .addKey(class_1802.field_8285));

        provider.accept("netherite_equipment", create(class_3417.field_21866)
                .addKey(class_1802.field_22025)
                .addKey(class_1802.field_22026)
                .addKey(class_1802.field_22024)
                .addKey(class_1802.field_22023)
                .addKey(class_1802.field_22022)
                .addKey(class_1802.field_49814)
                .addKey(class_1802.field_22027)
                .addKey(class_1802.field_22028)
                .addKey(class_1802.field_22029)
                .addKey(class_1802.field_22030));

        provider.accept("leather_equipment", create(class_3417.field_14581)
                .addKey(class_1802.field_18138)
                .addKey(class_1802.field_8267)
                .addKey(class_1802.field_8577)
                .addKey(class_1802.field_8570)
                .addKey(class_1802.field_8370)
                .addKey(class_1802.field_8745)
                .addKey(class_1802.field_8175)
                .addKey(class_1802.field_42716)
                .addKey(class_1802.field_47831)
                .addKey(class_1802.field_8245));

        provider.accept("exoskeletal", create(class_3417.field_14684)
                .addKey(class_1802.field_47830)
                .addKey(class_1802.field_8161)
                .addKey(class_1802.field_8618)
                .setPitch(1.8f)
                .setVolume(0.5f));

        provider.accept("enchanting_books", create(class_3417.field_19197)
                .addKey(class_1802.field_8598)
                .addKey(class_1802.field_8287)
                .setVolume(0.2f)
                .setPitch(0.01f));

        provider.accept("crop_food", create(class_3417.field_17610)
                .addKey(ConventionalItemTags.VEGETABLE_FOODS)
                .addKey(ConventionalItemTags.FRUIT_FOODS)
                .addKey(ConventionalItemTags.BERRY_FOODS)
                .addKey(ConventionalItemTags.BREAD_FOODS)
                .setVolume(1.0f)
                .setPitch(1.76f));

        provider.accept("bowl_food", create(class_3417.field_18269)
                .addKey(ConventionalItemTags.SOUP_FOODS)
                .setVolume(0.5f)
                .setPitch(1.58f));

        provider.accept("meat_and_fish", create(class_3417.field_15004)
                 .addKey(ConventionalItemTags.RAW_FISH_FOODS)
                .addKey(ConventionalItemTags.RAW_MEAT_FOODS)
                .addKey(ConventionalItemTags.COOKED_FISH_FOODS)
                .addKey(ConventionalItemTags.COOKED_MEAT_FOODS)
                .setPitch(1.8f)
                .setVolume(0.20f));

        provider.accept("elytra", create(class_3417.field_14966)
                .addKey(class_1802.field_8833));

        provider.accept("trident", create(class_3417.field_15213)
                .addKey(class_1802.field_8547));

        provider.accept("bows", create(class_3417.field_14600)
                .addKey(class_1802.field_8102)
                .addKey(class_1802.field_8399));

        provider.accept("fishing_rods", create(class_3417.field_28037)
                .addKey(class_1802.field_8378));

        provider.accept("flint_and_steel", create(class_3417.field_15145)
                .addKey(class_1802.field_8884));

        provider.accept("dyes", create(class_3417.field_28391)
                .addKey(ConventionalItemTags.DYES));

        provider.accept("papers", create(class_3417.field_17481)
                .addKey(class_1802.field_8407)
                .addKey(class_1802.field_8204)
                .addKey(class_1802.field_8895));

        provider.accept("fireworks", create(class_3417.field_15227)
                .addKey(class_1802.field_8639));

        provider.accept("ingot_metals", create(class_3417.field_15044)
                .addKey(class_1802.field_8620)
                .addKey(class_1802.field_8695)
                .addKey(class_1802.field_22020)
                .addKey(class_1802.field_27022)
                .addKey(class_1802.field_8675)
                .addKey(class_1802.field_8397)
                .addKey(class_1802.field_22021)
                .addKey(class_1802.field_33402)
                .addKey(class_1802.field_33400)
                .addKey(class_1802.field_33401));

        provider.accept("shiny_metals", create(class_3417.field_26944)
                .addKey(class_1802.field_27063)
                .addKey(class_1802.field_8155)
                .addKey(class_1802.field_8687)
                .addKey(class_1802.field_8759)
                .addKey(class_1802.field_8477));

        provider.accept("bowl", create(class_3417.field_15227)
                .addKey(class_1802.field_8428)
                .setPitch(1.85f)
                .setVolume(0.25f));

        provider.accept("oak_boat", create(class_3417.field_14808)
                .addKey(class_1802.field_8533)
                .addKey(class_1802.field_38216)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("birch_boat", create(CustomSounds.BLOCK_BIRCH_PLANKS_HIT.get())
                .addKey(class_1802.field_8442)
                .addKey(class_1802.field_38218)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("spruce_boat", create(CustomSounds.BLOCK_SPRUCE_PLANKS_HIT.get())
                .addKey(class_1802.field_8486)
                .addKey(class_1802.field_38217)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("jungle_boat", create(CustomSounds.BLOCK_JUNGLE_PLANKS_HIT.get())
                .addKey(class_1802.field_8730)
                .addKey(class_1802.field_38212)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("acacia_boat", create(CustomSounds.BLOCK_ACACIA_PLANKS_HIT.get())
                .addKey(class_1802.field_8094)
                .addKey(class_1802.field_38213)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("dark_oak_boat", create(class_3417.field_14808)
                .addKey(class_1802.field_8138)
                .addKey(class_1802.field_38214)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("cherry_boat", create(class_3417.field_14808)
                .addKey(class_1802.field_42706)
                .addKey(class_1802.field_42707)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("mangrove_boat", create(CustomSounds.BLOCK_MANGROVE_PLANKS_HIT.get())
                .addKey(class_1802.field_37531)
                .addKey(class_1802.field_38215)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("bamboo_raft", create(class_3417.field_40059)
                .addKey(class_1802.field_40224)
                .addKey(class_1802.field_40225)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("minecarts", create(class_3417.field_14988)
                .addKey(class_1802.field_8045)
                .addKey(class_1802.field_8388)
                .addKey(class_1802.field_8063)
                .addKey(class_1802.field_8069)
                .addKey(class_1802.field_8836)
                .addKey(class_1802.field_8220)
                .setPitch(1.75f)
                .setVolume(0.75f));

        provider.accept("dirty_metals", create(class_3417.field_14697)
                .addKey(class_1802.field_8713)
                .addKey(class_1802.field_8665)
                .addKey(class_1802.field_8145)
                .addKey(class_1802.field_8696)
                .addKey(class_1802.field_8725)
                .addKey(class_1802.field_8801)
                .addKey(class_1802.field_8054));

        provider.accept("shards", create(class_3417.field_42580)
                .addKey(class_1802.field_38974)
                .addKey(class_3489.field_42610));

        provider.accept("smithing_templates", create(class_3417.field_15233)
                .addKey(class_1802.field_41946)
                .addKey(class_6862.method_40092(class_7924.field_41197, class_2960.method_60654("trim_templates"))));

        provider.accept("filled_buckets", create(class_3417.field_15126)
                .addKey(ConventionalItemTags.WATER_BUCKETS)
                .addKey(ConventionalItemTags.ENTITY_WATER_BUCKETS));

        provider.accept("moo", create(class_3417.field_14780)
                .addKey(class_1802.field_8103));

        provider.accept("banner_templates", create(class_3417.field_14628)
                .addKey(class_1802.field_8573)
                .addKey(class_1802.field_8498)
                .addKey(class_1802.field_18674)
                .addKey(class_1802.field_8159)
                .addKey(class_1802.field_8891)
                .addKey(class_1802.field_23831));

        provider.accept("brewing_items", create(class_3417.field_14779)
                .addKey(class_1802.field_8469)
                .addKey(class_1802.field_8574)
                .addKey(class_1802.field_8613)
                .addKey(class_1802.field_8436)
                .addKey(class_1802.field_50140)
                .addKey(class_1802.field_8150));

        provider.accept("wet_mob_drops", create(class_3417.field_14640)
                .addKey(class_1802.field_8777)
                .addKey(class_1802.field_20414)
                .addKey(class_1802.field_20417)
                .addKey(class_1802.field_8711)
                .addKey(class_1802.field_8183)
                .addKey(class_1802.field_8073)
                .addKey(class_1802.field_8680)
                .addKey(class_1802.field_8511)
                .addKey(class_1802.field_8597)
                .addKey(class_1802.field_8135)
                .addKey(class_1802.field_8070));

        provider.accept("sculk", create(class_3417.field_37353)
                .addKey(class_1802.field_38746));

        provider.accept("bones", create(class_3417.field_15200)
                .addKey(class_1802.field_8606)
                .addKey(class_1802.field_8324));

        // Spawn Eggs
//        for (Item item : Registries.ITEM) {
//            if (item instanceof SpawnEggItem spawnEggItem) {
//                EntityType<?> entityType = spawnEggItem.getEntityType(null);
//                Identifier soundEventID = getAmbientSoundForEntity(entityType);
//                @Nullable SoundEvent soundEvent = Registries.SOUND_EVENT.get(soundEventID);
//                if (soundEvent != null) {
//                    String spawnEggName = Registries.ITEM.getId(spawnEggItem).getPath();
//                    provider.accept(spawnEggName, create(soundEvent).addKey(spawnEggItem));
//                } else {
//                    LOGGER.warn("Could not find ambient sound event for entity type " + entityType.getTranslationKey());
//                }
//            }
//        }

        List<class_1792> spawnEggs = class_7923.field_41178.method_10220().filter(item -> item instanceof class_1826).toList();
        provider.accept("spawn_eggs", create(class_3417.field_44588)
                .addKey(class_1802.field_8803)
                .addMultipleKeys(spawnEggs.toArray(class_1792[]::new)));
    }

//    private Identifier getAmbientSoundForEntity(EntityType<?> entityType) {
//        return Identifier.of("entity." + entityType.getUntranslatedName() + ".ambient");
//    }
}
/*?}*/
