package dev.imb11.sounds.mixin;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ActionController;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value = ActionController.ActionControllerElement.class, remap = false)
public abstract class ActionControllerElementMixin extends ControllerWidget<ActionController> {
    public ActionControllerElementMixin(ActionController control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
    }

    @Inject(method = "executeAction", at = @At("HEAD"), cancellable = true)
    public void $dontClickSound(CallbackInfo ci) {
        if(this.control.option().name().getString().contains(class_2561.method_43471("sounds.config.preview.name").getString().split(" ")[0])) {
            ci.cancel();
            control.option().action().accept(screen, control.option());
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if(this.control.option().name().getString().contains(class_2561.method_43471("sounds.config.preview.name").getString().split(" ")[0])) {
            hovered = method_25405(mouseX, mouseY);

            class_2561 name = control.option().changed() ? modifiedOptionName : control.option().name();
            class_2561 shortenedName = class_2561.method_43470(GuiUtils.shortenString(name.getString(), textRenderer, getDimension().width() - getControlWidth() - getXPadding() - 7, "...")).method_10862(name.method_10866());

            drawButtonRect(graphics, getDimension().x(), getDimension().y(), getDimension().xLimit(), getDimension().yLimit(), hovered || focused, isAvailable());
            graphics.method_51439(textRenderer, shortenedName, getDimension().x() + getXPadding(), getTextY(), getValueColor(), true);

            String valueText = "LISTEN";
            graphics.method_51433(textRenderer, valueText, getDimension().xLimit() - textRenderer.method_1727(valueText) - getXPadding(), getTextY(), getValueColor(), true);
            if (isHovered()) {
                drawHoveredControl(graphics, mouseX, mouseY, delta);
            }
        } else {
            super.method_25394(graphics, mouseX, mouseY, delta);
        }
    }
}
