package dev.imb11.sounds.mixin;

import dev.imb11.mru.LoaderUtils;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.api.event.SoundDefinitionReplacementEvent;
import dev.imb11.sounds.config.ModConfig;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.dynamic.TagPairHelper;
import dev.imb11.sounds.util.BlockAccessor;
import net.minecraft.class_2404;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4970.class)
public abstract class BlockSoundMixin implements BlockAccessor {
    @Unique
    private @Nullable TagPair sounds$associatedTagPair = null;
    @Unique
    private boolean sounds$hasFetched = false;

    @Override
    public void sounds$prepareTagPair(class_2960 value) {
        try {
            if(class_310.method_1551() == null) return;
            if(((Object) this) instanceof class_2404) {
                sounds$hasFetched = true;
                return;
            }

            if(SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely || SoundsConfig.get(WorldSoundsConfig.class).ignoredBlocks.contains(value.toString()))
                return;

            @Nullable TagPair pair = TagPairHelper.get(value);
            sounds$associatedTagPair = pair;
            sounds$hasFetched = true;
        } catch (Exception ignored) {
            if (LoaderUtils.isDevelopmentEnvironment())
                SoundsClient.LOGGER.warn("Early-load attempt at getting custom sound block group failed. Ignoring for now. {}", value.toString());
        }
    }

    @Inject(method = "getSoundType", at = @At("HEAD"), cancellable = true)
    public void $manageCustomSounds(class_2680 state, CallbackInfoReturnable<class_2498> cir) {
        try {
            var id = class_7923.field_41175.method_10221(state.method_26204());
            if(!sounds$hasFetched) {
                sounds$prepareTagPair(id);
            }

            if(SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely || SoundsConfig.get(WorldSoundsConfig.class).ignoredBlocks.contains(id.toString()))
                return;
        } catch (Exception ignored) {
            if (LoaderUtils.isDevelopmentEnvironment())
                SoundsClient.LOGGER.warn("Failed initial block fetch for blockstate {}", state.toString());
        }

        class_2498 group = null;
        if(sounds$associatedTagPair != null) {
            group = sounds$associatedTagPair.getGroup();
        }

        var eventResponse = SoundDefinitionReplacementEvent.fire(group);

        if (eventResponse.response() == SoundDefinitionReplacementEvent.ResponseType.OVERRIDE) {
            var replacement = eventResponse.override();

            if (replacement != null) {
                cir.setReturnValue(replacement);
            }
        }

        // CANCEL - Use vanillas, not ours.
        if (eventResponse.response() == SoundDefinitionReplacementEvent.ResponseType.CANCEL) return;

        // PASS - No override, continue with normal planned sound group.
        if (group != null) {
            cir.setReturnValue(group);
        }
    }
}
