package dev.imb11.sounds.mixin.compat;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import net.mehvahdjukaar.amendments.common.block.DirectionalCakeBlock;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(DirectionalCakeBlock.class)
public class AmendmentsDirectionalCakeMixin {
    @Unique
    private static long lastPlayed = 0;
    @Unique
    private static final long COOLDOWN = 150;
    @Inject(method = "eatSliceD", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;)V"))
    private static void eatCake(class_1936 level, class_2338 pos, class_2680 state, class_1657 player, class_2350 dir, CallbackInfoReturnable<class_1269> cir) {
        // nom nom nom
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastPlayed > COOLDOWN) {
            SoundsConfig.get(WorldSoundsConfig.class).cakeEatSoundEffect.playSound();
            lastPlayed = currentTime;
        }
    }
}
