package dev.imb11.sounds.mixin.ui;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.util.MixinStatics;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1703.class)
public abstract class ItemTransferSoundEffects {
    @Shadow
    public abstract class_1735 getSlot(int index);

    @Shadow public abstract class_1799 getCarried();

    @Inject(method = "doClick", at = @At("HEAD"))
    void $item_transfer_sound_effects(int slotIndex, int button, class_1713 actionType, class_1657 player, CallbackInfo ci) {
        if (!(player instanceof class_746)) return;
        if (slotIndex < 0) return;

        class_1799 itemStack = getSlot(slotIndex).method_7677();
        if (actionType == class_1713.field_7790) {
            if (itemStack.method_7960()) {
                class_1799 cursorStack = this.getCarried();
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(cursorStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            } else {
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            }
        } else if (actionType == class_1713.field_7793) {
            class_1799 cursorStack = this.getCarried();
            SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(cursorStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
        } else if (actionType == class_1713.field_7791) {
            if (itemStack.method_7960()) {
                class_1799 buttonStack = player.method_31548().method_5438(button);
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(buttonStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            } else {
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            }
        } else if (actionType == class_1713.field_7794) {
            if (itemStack.method_7960()) {
                class_1799 cursorStack = this.getCarried();
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(cursorStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            } else {
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            }
        } else if (actionType == class_1713.field_7796) {
            SoundsConfig.get(UISoundsConfig.class).itemCopySoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
        }

        MixinStatics.previousAction = actionType;
    }
}
