package dev.imb11.sounds.mixin.world.mechanics;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.sound.context.RepeaterSoundContext;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2462;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2462.class)
public class RepeaterBlockMixin {
    @Inject(method = "useWithoutItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift = At.Shift.AFTER))
    public void $repeater_use_sound_effect(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit, CallbackInfoReturnable<class_1269> cir) {
        if (world.field_9236) {
            int delayLevel = state.method_11654(class_2462.field_11451);
            SoundsConfig.get(WorldSoundsConfig.class).repeaterUseSoundEffect.playDynamicSound(delayLevel, RepeaterSoundContext.of());
        }
    }
}
