package dev.imb11.sounds.sound;

import dev.imb11.sounds.api.config.DynamicConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;

public class HotbarDynamicConfiguredSound extends DynamicConfiguredSound<class_1799, ItemStackSoundContext> {
    public HotbarDynamicConfiguredSound(String id, class_2960 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    public HotbarDynamicConfiguredSound(String id, class_3414 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    public HotbarDynamicConfiguredSound(String id, class_6880.class_6883<class_3414> soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    @Override
    public void playDynamicSound(class_1799 context, ItemStackSoundContext contextHandler) {
        // If item stack is empty and UISounds.ignoreEmptyInventorySlots is true, don't play any sound, else, normal behavior
        if (context.method_7960() && SoundsConfig.get(UISoundsConfig.class).ignoreEmptyHotbarSlots) return;

        super.playDynamicSound(context, contextHandler);
    }
}
