package dev.imb11.sounds.sound;

import dev.imb11.sounds.util.MixinStatics;
import dev.imb11.sounds.api.config.DynamicConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import java.util.HashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;

public class InventoryDynamicConfiguredSound extends DynamicConfiguredSound<class_1799, ItemStackSoundContext> {
    private static final HashMap<String, Long> itemTypeCooldownMap = new HashMap<>();

    public InventoryDynamicConfiguredSound(String id, class_2960 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    public InventoryDynamicConfiguredSound(String id, class_3414 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    public InventoryDynamicConfiguredSound(String id, class_6880.class_6883<class_3414> soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    @Override
    public void playDynamicSound(class_1799 context, ItemStackSoundContext contextHandler) {
        // If item stack is empty and UISounds.ignoreEmptyInventorySlots is true, don't play any sound, else, normal behavior
        if ((context.method_7960() && SoundsConfig.get(UISoundsConfig.class).ignoreEmptyInventorySlots)
                || MixinStatics.temporarilyDisableInventorySounds) return;

        if(!context.method_7960()) {
            String itemId = context.method_7909().method_7876();
            float cooldownDuration = SoundsConfig.get(UISoundsConfig.class).itemSoundCooldown * 1000f;
            long currentTime = System.currentTimeMillis();

            // If the item type is on cooldown, don't play the sound
            if (itemTypeCooldownMap.containsKey(itemId)) {
                long lastPlayedTime = itemTypeCooldownMap.get(itemId);
                if (currentTime - lastPlayedTime < cooldownDuration) return;
            }

            // Update the cooldown map with the current time plus the cooldown duration
            itemTypeCooldownMap.put(itemId, currentTime);
        }

        super.playDynamicSound(context, contextHandler);
    }
}
