/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import java.util.ArrayList;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class TagPair {
    private static final Codec<class_2498> BLOCK_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("pitch").forGetter(class_2498::method_10599), (App)Codec.FLOAT.fieldOf("volume").forGetter(class_2498::method_10597), (App)class_3414.field_41698.fieldOf("break").forGetter(class_2498::method_10595), (App)class_3414.field_41698.fieldOf("step").forGetter(class_2498::method_10594), (App)class_3414.field_41698.fieldOf("place").forGetter(class_2498::method_10598), (App)class_3414.field_41698.fieldOf("hit").forGetter(class_2498::method_10596), (App)class_3414.field_41698.fieldOf("fall").forGetter(class_2498::method_10593)).apply((Applicative)instance, class_2498::new));
    public static final Codec<TagPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagList.getCodec(class_7923.field_41175.method_30517()).fieldOf("keys").forGetter(TagPair::getKeys), (App)BLOCK_GROUP_CODEC.fieldOf("group").forGetter(TagPair::getGroup), (App)Codec.BOOL.fieldOf("enabled").forGetter(TagPair::isEnabled)).apply((Applicative)instance, TagPair::new));
    private final TagList<class_2248> keys;
    private final class_2498 group;
    private boolean enabled;

    public TagList<class_2248> getKeys() {
        return this.keys;
    }

    public class_2498 getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TagPair(TagList<class_2248> keys, class_2498 group) {
        this.keys = keys;
        this.group = group;
        this.enabled = true;
    }

    public TagPair(TagList<class_2248> keys, class_2498 group, boolean enabled) {
        this(keys, group);
        this.enabled = enabled;
    }

    public static class Builder {
        private final TagList<class_2248> keys = new TagList(new ArrayList());
        private class_2498 group = class_2498.field_11544;
        private boolean enabled = true;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder group(float pitch, float volume, class_3414 breakSound, class_3414 stepSound, class_3414 placeSound, class_3414 hitSound, class_3414 fallSound) {
            this.group = new class_2498(pitch, volume, breakSound, stepSound, placeSound, hitSound, fallSound);
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(class_2248 ... keys) {
            for (class_2248 key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(class_2248 key) {
            this.keys.add((Either<class_5321<class_2248>, class_6862<class_2248>>)Either.left((Object)((class_5321)class_7923.field_41175.method_29113((Object)key).orElseThrow(() -> new RuntimeException("TagPair.Builder: Could not find RegistryKey for " + key.toString())))));
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(class_6862<class_2248> ... keys) {
            for (class_6862<class_2248> key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(class_6862<class_2248> key) {
            this.keys.add((Either<class_5321<class_2248>, class_6862<class_2248>>)Either.right(key));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TagPair build() {
            return new TagPair(this.keys, this.group, this.enabled);
        }
    }
}

