/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.lightmapview.mixin;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.enchanted.lightmapview.LightmapView;
import java.io.IOException;
import java.nio.file.Path;
import java.util.OptionalInt;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_12137;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1060.class})
public class TextureManagerMixin {
    @Unique
    private class_12137 egLightmapView$sampler = RenderSystem.getSamplerCache().method_75293(AddressMode.REPEAT, AddressMode.REPEAT, FilterMode.NEAREST, FilterMode.NEAREST);

    @Inject(at={@At(value="TAIL")}, method={"dumpAllSheets"})
    private void egLightmapView$dumpLightmap(Path debugScreenshotsPath, CallbackInfo ci) {
        GpuBuffer quadData;
        GpuTextureView lightmapTextureView = class_310.method_1551().field_1773.method_22974().method_71650();
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder commandEncoder = device.createCommandEncoder();
        int lightmapTextureDimensions = 16;
        int lightmapSize = lightmapTextureView.texture().getFormat().pixelSize() * 16 * 16;
        try (class_9799 byteBufferBuilder = class_9799.method_72201((int)(class_290.field_1592.getVertexSize() * 4));){
            class_287 bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22912(0.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 1.0f, 0.0f);
            bufferBuilder.method_22912(0.0f, 1.0f, 0.0f);
            try (class_9801 meshData = bufferBuilder.method_60800();){
                quadData = device.createBuffer(() -> "Scratch lightmap quad", 32, meshData.method_60818());
            }
        }
        GpuTexture scratchTexture = device.createTexture("Scratch light texture", 10, TextureFormat.RGBA8, 16, 16, 1, 1);
        GpuTextureView scratchTextureView = device.createTextureView(scratchTexture);
        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(6);
        try (RenderPass renderPass = commandEncoder.createRenderPass(() -> "Scratch light texture blit", scratchTextureView, OptionalInt.empty());){
            renderPass.setPipeline(class_10799.field_57928);
            renderPass.setVertexBuffer(0, quadData);
            renderPass.setIndexBuffer(indexBuffer, autoStorageIndexBuffer.method_31924());
            renderPass.bindTexture("InSampler", lightmapTextureView, this.egLightmapView$sampler);
            renderPass.drawIndexed(0, 0, 6, 1);
        }
        GpuBuffer outputImageBuffer = device.createBuffer(() -> "Lightmap buffer", 9, lightmapSize);
        commandEncoder.copyTextureToBuffer(scratchTextureView.texture(), outputImageBuffer, 0, () -> {
            try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(outputImageBuffer, true, false);){
                class_1011 nativeImage = new class_1011(16, 16, false);
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        int col = mappedView.data().getInt((x + y * 16) * scratchTexture.getFormat().pixelSize());
                        nativeImage.method_4305(x, y, col);
                    }
                }
                nativeImage.method_4314(debugScreenshotsPath.resolve("minecraft_lightmap.png"));
                nativeImage.close();
                outputImageBuffer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LightmapView.LOGGER.info("Dumped lightmap to screenshots/debug/minecraft_lightmap.png");
            quadData.close();
            scratchTexture.close();
            scratchTextureView.close();
            outputImageBuffer.close();
        }, 0);
    }
}

