/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib;

import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.launch.MixinBootstrap;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.event.mod.ModIntegration;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.internal.registry.BlueDataComponentRegistry;
import software.bluelib.internal.registry.BlueEntityRegistry;
import software.bluelib.internal.registry.BlueNetworkRegistry;
import software.bluelib.internal.registry.BlueRecipeSerializerRegistry;
import software.bluelib.internal.registry.BlueRecipeTypeRegistry;
import software.bluelib.internal.registry.molang.BlueMoLangContextRegistry;

@ApiStatus.Internal
public class BlueLibCommon {
    private BlueLibCommon() {
    }

    public static void init() {
        if (BlueLibCommon.isDeveloperMode().booleanValue()) {
            BlueLibConstants.SCHEDULER.schedule(() -> {
                ModIntegration.checkSupportMods();
                BaseLogger.logBlueLib((Component)Component.literal((String)"**************************************************"));
                BaseLogger.logBlueLib((Component)Component.literal((String)"                                                  "));
                BaseLogger.logBlueLib(BlueTranslation.translate("mod.thank_you"));
                BaseLogger.logBlueLib(BlueTranslation.translate("mod.thank_you.subtitle"));
                BaseLogger.logBlueLib((Component)Component.literal((String)"                                                  "));
                BaseLogger.logBlueLib((Component)Component.literal((String)"**************************************************"));
                BlueLibConstants.SCHEDULER.shutdown();
            }, 5L, TimeUnit.SECONDS);
        }
    }

    public static void doRegistration() {
        BlueLibConstants.init();
        MixinBootstrap.init();
        InternalNetworkRegistry.networkServer();
        BlueEntityRegistry.init();
        BlueRecipeTypeRegistry.init();
        BlueRecipeSerializerRegistry.init();
        BlueMoLangContextRegistry.init();
        BlueDataComponentRegistry.init();
    }

    public static void doClientRegistration() {
        InternalNetworkRegistry.networkClient();
    }

    @NotNull
    public static Boolean isDeveloperMode() {
        boolean isDevMode = BlueLibConstants.PlatformHelper.PLATFORM.isDevelopmentEnvironment();
        if (isDevMode) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, (Component)Component.literal((String)"Running in Developer mode."));
        }
        return isDevMode;
    }

    protected static class InternalNetworkRegistry {
        protected InternalNetworkRegistry() {
        }

        @NotNull
        private static BlueNetworkRegistry getNetwork() {
            return new BlueNetworkRegistry();
        }

        private static void networkServer() {
            NetworkRegistry.registerC2SPacketProvider(InternalNetworkRegistry.getNetwork());
        }

        private static void networkClient() {
            NetworkRegistry.registerS2CPacketProvider(InternalNetworkRegistry.getNetwork());
        }
    }
}

