/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.pos;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.pos.BlockPos;

public record BlockPosCache(@NotNull Integer x, @NotNull Integer y, @NotNull Integer z) {
    @NotNull
    public static final Codec<BlockPosCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)BlockPosCache.readFromNBT(tag));
    }, blockPosCache -> {
        CompoundTag tag = new CompoundTag();
        blockPosCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<BlockPosCache> BLOCK_POS_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putInt("x", this.x.intValue());
        pTag.putInt("y", this.y.intValue());
        pTag.putInt("z", this.z.intValue());
    }

    @NotNull
    public static BlockPosCache readFromNBT(@NotNull CompoundTag pTag) {
        return new BlockPosCache(pTag.getInt("x"), pTag.getInt("y"), pTag.getInt("z"));
    }

    @NotNull
    public static BlockPosCache construct(@NotNull BlockPos pBlockPos) {
        return new BlockPosCache(pBlockPos.x(), pBlockPos.y(), pBlockPos.z());
    }

    public static net.minecraft.core.BlockPos convert(@NotNull BlockPos pPos) {
        return new net.minecraft.core.BlockPos(pPos.x().intValue(), pPos.y().intValue(), pPos.z().intValue());
    }

    public static net.minecraft.core.BlockPos convert(@NotNull BlockPosCache pPos) {
        return new net.minecraft.core.BlockPos(pPos.x().intValue(), pPos.y().intValue(), pPos.z().intValue());
    }
}

