/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.range;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.range.ByteRange;

public record ByteRangeCache(@NotNull Byte min, @NotNull Byte max) {
    @NotNull
    public static final Codec<ByteRangeCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)ByteRangeCache.readFromNBT(tag));
    }, byteRangeCache -> {
        CompoundTag tag = new CompoundTag();
        byteRangeCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<ByteRangeCache> BYTE_RANGE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putByte("Min", this.min.byteValue());
        pTag.putByte("Max", this.max.byteValue());
    }

    @NotNull
    public static ByteRangeCache readFromNBT(@NotNull CompoundTag pTag) {
        return new ByteRangeCache(pTag.getByte("Min"), pTag.getByte("Max"));
    }

    public byte getRandomValue() {
        return (byte)ThreadLocalRandom.current().nextInt(this.min.byteValue(), this.max + 1);
    }

    @NotNull
    public static ByteRangeCache construct(@NotNull ByteRange pByteRange) {
        return new ByteRangeCache(pByteRange.min(), pByteRange.max());
    }
}

