/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.molang.MoLangContext;
import software.bluelib.api.molang.MoLangRuntime;

public abstract class BaseMoLangContext
implements MoLangContext {
    @NotNull
    protected final Map<String, Object> variables = new HashMap<String, Object>();
    @NotNull
    protected final Map<String, BiFunction<List<Object>, MoLangRuntime, Object>> functions = new HashMap<String, BiFunction<List<Object>, MoLangRuntime, Object>>();

    public void registerFunction(@NotNull String pName, @Nullable BiFunction<List<Object>, MoLangRuntime, Object> pFunction) {
        this.functions.put(pName, pFunction);
    }

    public void setVariable(@NotNull String pName, @Nullable Supplier<?> pSupplier) {
        this.variables.put(pName, pSupplier);
    }

    public void setVariable(@NotNull String pName, @Nullable Object pSupplier) {
        this.variables.put(pName, pSupplier instanceof Supplier ? pSupplier : () -> pSupplier);
    }

    @Override
    @Nullable
    public Object getVariable(@NotNull String pName) {
        Supplier supplier = (Supplier)this.variables.get(pName);
        return supplier != null ? supplier.get() : null;
    }

    @Override
    @Nullable
    public Object callFunction(@NotNull String pName, @Nullable List<Object> pArguments) {
        BiFunction<List<Object>, MoLangRuntime, Object> fn = this.functions.get(pName);
        return fn != null ? fn.apply(pArguments, null) : null;
    }
}

