/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.math;

import java.util.concurrent.ThreadLocalRandom;
import software.bluelib.api.molang.MoLangNamespaceUtils;
import software.bluelib.api.molang.context.BaseMoLangContext;
import software.bluelib.api.molang.context.math.MoLangMathUtils;

public class RandomMoLang
extends BaseMoLangContext {
    public RandomMoLang() {
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("random"), (args, runtime) -> {
            if (args == null || args.isEmpty()) {
                return ThreadLocalRandom.current().nextDouble();
            }
            if (args.size() == 1) {
                return ThreadLocalRandom.current().nextDouble(MoLangMathUtils.toDouble(args.getFirst()));
            }
            double min = MoLangMathUtils.toDouble(args.get(0));
            double max = MoLangMathUtils.toDouble(args.get(1));
            return ThreadLocalRandom.current().nextDouble(min, max);
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("random_int"), (args, runtime) -> {
            int min = MoLangMathUtils.toDouble(args, 0).intValue();
            int max = MoLangMathUtils.toDouble(args, 1).intValue();
            return ThreadLocalRandom.current().nextInt(min, max + 1);
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("die_roll"), (args, runtime) -> {
            int sides = MoLangMathUtils.toDouble(args, 0).intValue();
            return 1.0 + ThreadLocalRandom.current().nextDouble() * (double)sides;
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("die_roll_integer"), (args, runtime) -> {
            int sides = MoLangMathUtils.toDouble(args, 0).intValue();
            return 1 + ThreadLocalRandom.current().nextInt(sides);
        });
    }
}

