/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.expression;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.molang.MoLangRuntime;

public record MoLangExpression(@NotNull String raw) {
    public MoLangExpression(@NotNull String raw) {
        this.raw = raw.trim();
    }

    @NotNull
    public static MoLangExpression parse(@NotNull String pRaw) {
        return new MoLangExpression(pRaw);
    }

    @Nullable
    public Object evaluate(@NotNull MoLangRuntime pRuntime) {
        if (this.raw.startsWith("query.")) {
            String remapped = "q." + this.raw.substring("query.".length());
            return new MoLangExpression(remapped).evaluate(pRuntime);
        }
        if (this.raw.startsWith("q.")) {
            String expr = this.raw.substring(2);
            if (expr.startsWith("math.")) {
                return new MoLangExpression(expr).evaluate(pRuntime);
            }
            return this.getObject(pRuntime, expr);
        }
        if (this.raw.startsWith("math.")) {
            return this.getObject(pRuntime, this.raw);
        }
        if (this.raw.equalsIgnoreCase("true")) {
            return true;
        }
        if (this.raw.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Double.parseDouble(this.raw);
        }
        catch (NumberFormatException e) {
            return this.raw;
        }
    }

    @Nullable
    private Object getObject(@NotNull MoLangRuntime pRuntime, @NotNull String pRaw) {
        if (pRaw.endsWith(")")) {
            String name = pRaw.substring(0, pRaw.indexOf(40));
            String argsRaw = pRaw.substring(pRaw.indexOf(40) + 1, pRaw.length() - 1);
            List<Object> args = this.parseArguments(argsRaw, pRuntime);
            return pRuntime.callFunction(name, args);
        }
        return pRuntime.getVariable(pRaw);
    }

    @NotNull
    private List<Object> parseArguments(@NotNull String pArgsRaw, @NotNull MoLangRuntime pRuntime) {
        ArrayList<Object> args = new ArrayList<Object>();
        int depth = 0;
        int start = 0;
        for (int i = 0; i < pArgsRaw.length(); ++i) {
            char c = pArgsRaw.charAt(i);
            if (c == '(') {
                ++depth;
                continue;
            }
            if (c == ')') {
                --depth;
                continue;
            }
            if (c != ',' || depth != 0) continue;
            String arg = pArgsRaw.substring(start, i).trim();
            if (!arg.isEmpty()) {
                args.add(MoLangExpression.parse(arg).evaluate(pRuntime));
            }
            start = i + 1;
        }
        String lastArg = pArgsRaw.substring(start).trim();
        if (!lastArg.isEmpty()) {
            args.add(MoLangExpression.parse(lastArg).evaluate(pRuntime));
        }
        return args;
    }
}

