/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.net.registry;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.api.utils.loader.LoaderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;
import software.bluelib.net.messages.client.loader.BlockEntityAnimTriggerPacket;
import software.bluelib.net.messages.client.loader.BlockEntityDataSyncPacket;
import software.bluelib.net.messages.client.loader.EntityAnimTriggerPacket;
import software.bluelib.net.messages.client.loader.EntityDataSyncPacket;
import software.bluelib.net.messages.client.loader.SingletonAnimTriggerPacket;
import software.bluelib.net.messages.client.loader.SingletonDataSyncPacket;
import software.bluelib.net.messages.client.loader.StopTriggeredBlockEntityAnimPacket;
import software.bluelib.net.messages.client.loader.StopTriggeredEntityAnimPacket;
import software.bluelib.net.messages.client.loader.StopTriggeredSingletonAnimPacket;

public class LoaderNetwork
extends NetworkRegistry {
    public static <D> void syncBlockEntityAnimData(@NotNull BlockPos pPos, @NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData, @NotNull ServerLevel pLevel) {
        LoaderNetwork.sendToAllPlayersTrackingBlock(pLevel, pPos, new BlockEntityDataSyncPacket<D>(pPos, pDataTicket, pData));
    }

    public static <D> void syncEntityAnimData(@NotNull Entity entity, boolean pIsReplacedEntity, @NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData) {
        LoaderNetwork.sendToAllPlayersTrackingEntity(entity, new EntityDataSyncPacket<D>(entity.getId(), pIsReplacedEntity, pDataTicket, pData));
    }

    public static <D> void syncSingletonAnimData(@NotNull BlueAnimatable pAnimatable, @NotNull Long pInstanceId, @NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData, @NotNull Entity pEntityToTrack) {
        String syncedId = LoaderUtils.getSyncedSingletonAnimatableId(pAnimatable);
        LoaderNetwork.sendToAllPlayersTrackingEntity(pEntityToTrack, new SingletonDataSyncPacket<D>(syncedId, pInstanceId, pDataTicket, pData));
    }

    public static void triggerBlockEntityAnim(@NotNull BlockPos pPos, @Nullable String pControllerName, @NotNull String pAnimName, @NotNull ServerLevel pLevel) {
        LoaderNetwork.sendToAllPlayersTrackingBlock(pLevel, pPos, new BlockEntityAnimTriggerPacket(pPos, pControllerName == null ? "" : pControllerName, pAnimName));
    }

    public static void triggerEntityAnim(@NotNull Entity pEntity, boolean pIsReplacedEntity, @Nullable String pControllerName, @NotNull String pAnimName) {
        LoaderNetwork.sendToAllPlayersTrackingEntity(pEntity, new EntityAnimTriggerPacket(pEntity.getId(), pIsReplacedEntity, pControllerName == null ? "" : pControllerName, pAnimName));
    }

    public static void triggerSingletonAnim(@NotNull String pAnimatableClassName, @NotNull Entity pEntityToTrack, @NotNull Long pInstanceId, @Nullable String pControllerName, @NotNull String pAnimName) {
        LoaderNetwork.sendToAllPlayersTrackingEntity(pEntityToTrack, new SingletonAnimTriggerPacket(pAnimatableClassName, pInstanceId, pControllerName == null ? "" : pControllerName, pAnimName));
    }

    public static void triggerSingletonAnim(@NotNull BlueAnimatable pAnimatable, @NotNull Entity pEntityToTrack, @NotNull Long pInstanceId, @Nullable String pControllerName, @NotNull String pAnimName) {
        String syncedId = LoaderUtils.getSyncedSingletonAnimatableId(pAnimatable);
        LoaderNetwork.triggerSingletonAnim(syncedId, pEntityToTrack, pInstanceId, pControllerName == null ? "" : pControllerName, pAnimName);
    }

    public static void stopTriggeredBlockEntityAnim(@NotNull BlockPos pPos, @NotNull ServerLevel pLevel, @Nullable String pControllerName, @Nullable String pAnimName) {
        LoaderNetwork.sendToAllPlayersTrackingBlock(pLevel, pPos, new StopTriggeredBlockEntityAnimPacket(pPos, pControllerName == null ? "" : pControllerName, pAnimName == null ? "" : pAnimName));
    }

    public static void stopTriggeredEntityAnim(@NotNull Entity pEntity, boolean pIsReplacedEntity, @Nullable String pControllerName, @Nullable String pAnimName) {
        LoaderNetwork.sendToAllPlayersTrackingEntity(pEntity, new StopTriggeredEntityAnimPacket(pEntity.getId(), pIsReplacedEntity, pControllerName == null ? "" : pControllerName, pAnimName == null ? "" : pAnimName));
    }

    public static void stopTriggeredSingletonAnim(@NotNull BlueAnimatable pAnimatable, @NotNull Entity pEntityToTrack, @NotNull Long pInstanceId, @Nullable String pControllerName, @Nullable String pAnimName) {
        String syncedId = LoaderUtils.getSyncedSingletonAnimatableId(pAnimatable);
        LoaderNetwork.sendToAllPlayersTrackingEntity(pEntityToTrack, new StopTriggeredSingletonAnimPacket(syncedId, pInstanceId, pControllerName == null ? "" : pControllerName, pAnimName == null ? "" : pAnimName));
    }
}

