/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.random;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class PityRandom<T>
extends Random {
    @NotNull
    protected final Map<T, Integer> selectionCounts = new LinkedHashMap<T, Integer>();
    @NotNull
    protected final List<T> values;
    @NotNull
    protected Integer totalSelections = 0;

    public PityRandom(@NotNull Collection<T> pValues) {
        this.values = new ArrayList<T>(pValues);
        for (T value : pValues) {
            this.selectionCounts.put(value, 0);
        }
    }

    @NotNull
    public static PityRandom<Double> ofRange(@NotNull Double pMin, @NotNull Double pMax, @NotNull Double pStep) {
        ArrayList<Double> range = new ArrayList<Double>();
        for (double d = pMin.doubleValue(); d <= pMax + 1.0E-9; d += pStep.doubleValue()) {
            range.add((double)Math.round(d * 1000000.0) / 1000000.0);
        }
        return new PityRandom<Double>(range);
    }

    @NotNull
    public T nextValue() {
        int maxCount = this.selectionCounts.values().stream().max(Integer::compareTo).orElse(1);
        LinkedHashMap<T, Double> weights = new LinkedHashMap<T, Double>();
        double totalWeight = 0.0;
        for (T value : this.values) {
            int count = this.selectionCounts.get(value);
            double weight = this.getWeight(value, count, maxCount);
            weights.put(value, weight);
            totalWeight += weight;
        }
        double roll = this.nextDouble() * totalWeight;
        double cumulative = 0.0;
        for (Map.Entry entry : weights.entrySet()) {
            if (!(roll <= (cumulative += ((Double)entry.getValue()).doubleValue()))) continue;
            Object selected = entry.getKey();
            this.selectionCounts.put(selected, this.selectionCounts.get(selected) + 1);
            Integer n = this.totalSelections;
            this.totalSelections = this.totalSelections + 1;
            return (T)selected;
        }
        return this.values.getFirst();
    }

    @NotNull
    protected Double getWeight(@NotNull T pValue, @NotNull Integer pCount, @NotNull Integer pMaxCount) {
        return Math.pow(2.0, pMaxCount - pCount);
    }

    public void resetCounts() {
        this.selectionCounts.replaceAll((k, v) -> 0);
        this.totalSelections = 0;
    }

    @NotNull
    public Integer getTotalSelections() {
        return this.totalSelections;
    }

    @NotNull
    public Map<T, Integer> getSelectionCounts() {
        return Collections.unmodifiableMap(this.selectionCounts);
    }
}

