/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.conversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class MathConverterUtils {
    private MathConverterUtils() {
    }

    @NotNull
    public static Double inchesToCentimeters(@NotNull Double pInches) {
        return pInches * 2.54;
    }

    @NotNull
    public static Double centimetersToInches(@NotNull Double pCentimeters) {
        return pCentimeters / 2.54;
    }

    @NotNull
    public static Double celsiusToFahrenheit(@NotNull Double pCelsius) {
        return pCelsius * 9.0 / 5.0 + 32.0;
    }

    @NotNull
    public static Double fahrenheitToCelsius(@NotNull Double pFahrenheit) {
        return (pFahrenheit - 32.0) * 5.0 / 9.0;
    }

    @NotNull
    public static Double kilometersToMiles(@NotNull Double pKilometers) {
        return pKilometers * 0.621371;
    }

    @NotNull
    public static Double milesToKilometers(@NotNull Double pMiles) {
        return pMiles / 0.621371;
    }

    @NotNull
    public static Date stringToDate(@NotNull String pDateStr, @NotNull String pFormat) throws ParseException {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pFormat);
            return formatter.parse(pDateStr);
        }
        catch (ParseException pException) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.log("error.date.format", pDateStr, pFormat), pException);
            throw pException;
        }
    }

    @NotNull
    public static String dateToString(@NotNull Date pDate, @NotNull String pFormat) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pFormat);
            return formatter.format(pDate);
        }
        catch (Exception pException) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.log("error.date.format", pDate, pFormat), pException);
            return pException.getMessage();
        }
    }
}

