/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.loader;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BufferUtils {
    private BufferUtils() {
    }

    @NotNull
    @ApiStatus.Internal
    public static VertexConsumer checkAndRefreshBuffer(boolean pIsReRender, @Nullable VertexConsumer pBuffer, @NotNull MultiBufferSource pBufferSource, @Nullable RenderType pRenderType) {
        VertexConsumer vertexConsumer;
        if (pRenderType == null) {
            return pBufferSource.getBuffer(RenderType.translucent());
        }
        if (pBuffer == null) {
            return pBufferSource.getBuffer(pRenderType);
        }
        if (pIsReRender) {
            return pBuffer;
        }
        VertexConsumer vertexConsumer2 = pBuffer;
        Objects.requireNonNull(vertexConsumer2);
        VertexConsumer vertexConsumer3 = vertexConsumer2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BufferBuilder.class, OutlineBufferSource.EntityOutlineGenerator.class, VertexMultiConsumer.Double.class}, (Object)vertexConsumer3, n)) {
                case 0: {
                    BufferBuilder builder = (BufferBuilder)vertexConsumer3;
                    if (builder.building) {
                        n = 1;
                        continue block5;
                    }
                    vertexConsumer = pBufferSource.getBuffer(pRenderType);
                    break block5;
                }
                case 1: {
                    OutlineBufferSource.EntityOutlineGenerator outlines = (OutlineBufferSource.EntityOutlineGenerator)vertexConsumer3;
                    if (!BufferUtils.bufferNeedsRefresh(outlines.delegate())) {
                        n = 2;
                        continue block5;
                    }
                    vertexConsumer = new OutlineBufferSource.EntityOutlineGenerator(pBufferSource.getBuffer(pRenderType), outlines.color());
                    break block5;
                }
                case 2: {
                    VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)vertexConsumer3;
                    if (!BufferUtils.bufferNeedsRefresh(pair.first) && !BufferUtils.bufferNeedsRefresh(pair.second)) {
                        n = 3;
                        continue block5;
                    }
                    vertexConsumer = new VertexMultiConsumer.Double(BufferUtils.bufferNeedsRefresh(pair.first) ? pBufferSource.getBuffer(pRenderType) : pair.first, BufferUtils.bufferNeedsRefresh(pair.second) ? pBufferSource.getBuffer(pRenderType) : pair.second);
                    break block5;
                }
                default: {
                    vertexConsumer = pBuffer;
                    break block5;
                }
            }
            break;
        }
        return vertexConsumer;
    }

    @ApiStatus.Internal
    public static boolean bufferNeedsRefresh(@NotNull VertexConsumer pBuffer) {
        VertexConsumer vertexConsumer = pBuffer;
        Objects.requireNonNull(vertexConsumer);
        VertexConsumer vertexConsumer2 = vertexConsumer;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BufferBuilder.class, OutlineBufferSource.EntityOutlineGenerator.class, VertexMultiConsumer.Double.class}, (Object)vertexConsumer2, n)) {
            case 0 -> {
                BufferBuilder builder = (BufferBuilder)vertexConsumer2;
                if (!builder.building) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                OutlineBufferSource.EntityOutlineGenerator outlines = (OutlineBufferSource.EntityOutlineGenerator)vertexConsumer2;
                yield BufferUtils.bufferNeedsRefresh(outlines.delegate());
            }
            case 2 -> {
                VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)vertexConsumer2;
                if (BufferUtils.bufferNeedsRefresh(pair.first) || BufferUtils.bufferNeedsRefresh(pair.second)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

