/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.math;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class AlgebraicUtils {
    private AlgebraicUtils() {
    }

    @NotNull
    public static Double[] solveQuadraticEquation(@NotNull Double pA, @NotNull Double pB, @NotNull Double pC) {
        double discriminant = pB * pB - 4.0 * pA * pC;
        if (discriminant < 0.0) {
            IllegalArgumentException throwable = new IllegalArgumentException("Number must be non-negative.");
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.error.calc", "quadratic"), throwable);
            return new Double[0];
        }
        double sqrtDiscriminant = Math.sqrt(discriminant);
        double root1 = (-pB.doubleValue() + sqrtDiscriminant) / (2.0 * pA);
        double root2 = (-pB.doubleValue() - sqrtDiscriminant) / (2.0 * pA);
        return new Double[]{root1, root2};
    }

    @NotNull
    public static Long factorial(@NotNull Integer pNumber) {
        if (pNumber < 0) {
            IllegalArgumentException throwable = new IllegalArgumentException("Number must be non-negative.");
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.error.calc", "factorial"), throwable);
            return 0L;
        }
        long result = 1L;
        for (int i = 1; i <= pNumber; ++i) {
            result *= (long)i;
        }
        return result;
    }

    @NotNull
    public static Integer calculateGCD(@NotNull Integer pA, @NotNull Integer pB) {
        while (pB != 0) {
            int temp = pB;
            pB = pA % pB;
            pA = temp;
        }
        return pA;
    }

    @NotNull
    public static <T> List<Set<T>> generatePowerSet(@NotNull Set<T> pSet) {
        ArrayList<Set<T>> powerSet = new ArrayList<Set<T>>();
        powerSet.add(new HashSet());
        for (T element : pSet) {
            ArrayList newSubsets = new ArrayList();
            for (Set set : powerSet) {
                HashSet<T> newSubset = new HashSet<T>(set);
                newSubset.add(element);
                newSubsets.add(newSubset);
            }
            powerSet.addAll(newSubsets);
        }
        return powerSet;
    }
}

