/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.math;

import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class RandomGenUtils {
    private RandomGenUtils() {
    }

    @NotNull
    public static Integer generateRandomInt(@NotNull Integer pMin, @NotNull Integer pMax) {
        if (pMin > pMax) {
            IllegalArgumentException throwable = new IllegalArgumentException("Minimum value must not be greater than maximum value.");
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.error.gen", "random integer"), throwable);
            return 0;
        }
        return pMin + (int)(Math.random() * (double)(pMax - pMin + 1));
    }

    @NotNull
    public static Double generateRandomDouble(@NotNull Double pMin, @NotNull Double pMax) {
        if (pMin > pMax) {
            IllegalArgumentException throwable = new IllegalArgumentException("Minimum value must not be greater than maximum value.");
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.error.gen", "random double"), throwable);
            return 0.0;
        }
        return pMin + Math.random() * (pMax - pMin);
    }

    @NotNull
    public static Boolean generateRandomBoolean() {
        return Math.random() < 0.5;
    }

    @NotNull
    public static String generateRandomString(@NotNull Integer pLength) {
        if (pLength < 0) {
            IllegalArgumentException throwable = new IllegalArgumentException("Length must be non-negative.");
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.error.gen", "random string"), throwable);
            return "unknown";
        }
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder(pLength);
        for (int i = 0; i < pLength; ++i) {
            int index = (int)(Math.random() * (double)characters.length());
            sb.append(characters.charAt(index));
        }
        return sb.toString();
    }

    @NotNull
    public static String generateRandomStringWithPrefix(@NotNull String pPrefix, @NotNull Integer pLength) {
        if (pLength < 0) {
            IllegalArgumentException throwable = new IllegalArgumentException("Length must be non-negative.");
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.error.gen", "random string with prefix"), throwable);
            return "unknown";
        }
        return pPrefix + RandomGenUtils.generateRandomString(pLength - pPrefix.length());
    }
}

