/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.minecraft;

import java.util.Collection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class ChunkUtils {
    private ChunkUtils() {
    }

    @NotNull
    public static Biome getBiomeOfChunk(@NotNull Level pLevel, @NotNull ChunkPos pChunkPos) {
        try {
            return (Biome)pLevel.getBiome(pChunkPos.getWorldPosition()).value();
        }
        catch (Exception pException) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.log("chunk.biome.error"), pException);
            throw pException;
        }
    }

    @NotNull
    public static Collection<BlockEntity> getChunkTileEntities(@NotNull Level pLevel, @NotNull ChunkPos pChunkPos) {
        try {
            LevelChunk chunk = pLevel.getChunk(pChunkPos.x, pChunkPos.z);
            return chunk.getBlockEntities().values();
        }
        catch (Exception pException) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.log("chunk.tile.error"), pException);
            throw pException;
        }
    }
}

