/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.scheduler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DelayedScheduler {
    @NotNull
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();

    @NotNull
    public static CompletableFuture<Void> schedule(@NotNull Runnable task, @NotNull Long delay, @NotNull TimeUnit unit) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        EXECUTOR_SERVICE.schedule(() -> {
            try {
                task.run();
                future.complete(null);
            }
            catch (Exception pException) {
                future.completeExceptionally(pException);
            }
        }, (long)delay, unit);
        return future;
    }

    @NotNull
    public static <A> CompletableFuture<A> schedule(@NotNull Supplier<A> supplier, @NotNull Long delay, @NotNull TimeUnit unit) {
        CompletableFuture future = new CompletableFuture();
        EXECUTOR_SERVICE.schedule(() -> {
            try {
                Object a = supplier.get();
                future.complete(a);
            }
            catch (Exception pException) {
                future.completeExceptionally(pException);
            }
        }, (long)delay, unit);
        return future;
    }
}

