/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.variant;

import com.google.gson.JsonElement;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.cache.ResourceCache;
import software.bluelib.loader.cache.variants.EntityCache;
import software.bluelib.loader.cache.variants.VariantCache;

public class ParameterUtils {
    private ParameterUtils() {
    }

    @NotNull
    public static Set<ResourceLocation> getAllEntities() {
        return ResourceCache.Server.getVariants().keySet();
    }

    @Nullable
    public static Set<String> getVariantsOfEntity(@NotNull ResourceLocation pEntity) {
        EntityCache entityCache = ParameterUtils.getOptionalEntityCache(pEntity);
        if (entityCache == null) {
            return null;
        }
        return entityCache.getVariantNames();
    }

    @Nullable
    public static JsonElement getParameterDataForVariant(@NotNull ResourceLocation pEntity, @NotNull String pVariantName, @NotNull String pParameter, @NotNull String pFallbackVariant) {
        JsonElement result = ParameterUtils.getParameterDataForVariant(pEntity, pVariantName, pParameter);
        if (result == null && !pFallbackVariant.equals(pVariantName)) {
            result = ParameterUtils.getParameterDataForVariant(pEntity, pFallbackVariant, pParameter);
        }
        return result;
    }

    @Nullable
    public static JsonElement getParameterDataForVariant(@NotNull ResourceLocation pEntity, @NotNull String pVariantName, @NotNull String pParameter) {
        EntityCache entityCache = ParameterUtils.getOptionalEntityCache(pEntity);
        if (entityCache == null) {
            return null;
        }
        VariantCache variantCache = ParameterUtils.getOptionalVariantCache(pEntity, pVariantName, entityCache);
        if (variantCache == null) {
            return null;
        }
        return ParameterUtils.getOptionalParameter(pEntity, pVariantName, pParameter, variantCache);
    }

    @Nullable
    public static JsonElement getOptionalParameter(@NotNull ResourceLocation pEntity, @NotNull String pVariantName, @NotNull String pParameter, @NotNull VariantCache pVariantCache) {
        JsonElement parameterElement = pVariantCache.getParameter(pParameter);
        if (parameterElement == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, "Parameter not found: " + pParameter + " in variant: " + pVariantName + " for entity: " + String.valueOf(pEntity));
        }
        return parameterElement;
    }

    @Nullable
    public static VariantCache getOptionalVariantCache(@NotNull ResourceLocation pEntity, @NotNull String pVariantName, @NotNull EntityCache pEntityCache) {
        VariantCache variantCache = pEntityCache.getVariant(pVariantName);
        if (variantCache == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, "Variant not found: " + pVariantName + " for entity: " + String.valueOf(pEntity));
            return null;
        }
        return variantCache;
    }

    @Nullable
    public static EntityCache getOptionalEntityCache(@NotNull ResourceLocation pEntity) {
        EntityCache entityCache = ResourceCache.Server.getVariants().get(pEntity);
        if (entityCache == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, "Entity not found: " + String.valueOf(pEntity));
            return null;
        }
        return entityCache;
    }
}

