/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.gui.logging;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.LogCache;
import software.bluelib.internal.BlueTranslation;

public class LoggerScreen
extends Screen {
    private int scrollOffset = 0;
    private static final int LINE_HEIGHT = 10;
    private boolean isDragging = false;
    private int dragStartY = 0;
    private int initialScrollOffset = 0;

    public LoggerScreen() {
        super(BlueTranslation.translate("ui.logger.title"));
    }

    protected void init() {
        super.init();
        this.scrollOffset = 0;
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int boxWidth = (int)((double)this.width * 0.9);
        int boxHeight = (int)((double)this.height * 0.9);
        int boxX = (this.width - boxWidth) / 2;
        int boxY = (this.height - boxHeight) / 2;
        pGuiGraphics.fill(boxX - 2, boxY - 22, boxX + boxWidth + 2, boxY + boxHeight + 2, -587202560);
        pGuiGraphics.fill(boxX, boxY - 20, boxX + boxWidth, boxY, -12303292);
        pGuiGraphics.drawCenteredString(this.font, this.title, boxX + boxWidth / 2, boxY - 15, 0xFFFFFF);
        List<LogCache.LogEntry> logEntries = LogCache.getLogs();
        ArrayList<RenderedLine> renderedLines = new ArrayList<RenderedLine>();
        for (LogCache.LogEntry entry : logEntries) {
            List<String> wrapped = this.wrapText(entry.message(), boxWidth - 15);
            for (String string : wrapped) {
                renderedLines.add(new RenderedLine(string, entry.color()));
            }
        }
        int maxVisibleLines = (boxHeight - 10) / 10;
        int maxOffset = Math.max(0, renderedLines.size() - maxVisibleLines);
        this.scrollOffset = Math.min(this.scrollOffset, maxOffset);
        int y = boxY + 5;
        for (int i = this.scrollOffset; i < renderedLines.size() && y < boxY + boxHeight - 10; y += 10, ++i) {
            RenderedLine renderedLine = (RenderedLine)renderedLines.get(i);
            pGuiGraphics.drawString(this.font, renderedLine.text(), boxX + 7, y, renderedLine.color().intValue());
        }
        if (renderedLines.size() > maxVisibleLines) {
            int scrollbarHeight = (int)((float)maxVisibleLines / (float)renderedLines.size() * (float)(boxHeight - 10));
            int n = boxY + 5 + (int)((float)this.scrollOffset / (float)renderedLines.size() * (float)(boxHeight - 10));
            pGuiGraphics.fill(boxX + boxWidth - 6, n, boxX + boxWidth - 3, n + scrollbarHeight, -7829368);
        }
    }

    @NotNull
    private List<String> wrapText(@NotNull String pText, @NotNull Integer pMaxWidth) {
        String[] segments;
        ArrayList<String> lines = new ArrayList<String>();
        for (String segment : segments = pText.split("\n")) {
            String[] words = segment.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                int wordWidth = this.font.width(word);
                if (wordWidth > pMaxWidth) {
                    while (!word.isEmpty()) {
                        int splitIndex = this.getSplitIndex(word, pMaxWidth);
                        lines.add(word.substring(0, splitIndex));
                        word = word.substring(splitIndex);
                    }
                    continue;
                }
                int lineWidth = this.font.width(String.valueOf(currentLine) + word + " ");
                if (lineWidth > pMaxWidth) {
                    lines.add(currentLine.toString().trim());
                    currentLine = new StringBuilder(word + " ");
                    continue;
                }
                currentLine.append(word).append(" ");
            }
            if (currentLine.isEmpty()) continue;
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    @NotNull
    private Integer getSplitIndex(@NotNull String pWord, @NotNull Integer pMaxWidth) {
        for (int i = 1; i <= pWord.length(); ++i) {
            if (this.font.width(pWord.substring(0, i)) <= pMaxWidth) continue;
            return i - 1;
        }
        return pWord.length();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int boxWidth = (int)((double)this.width * 0.9);
        int boxHeight = (int)((double)this.height * 0.9);
        int boxX = (this.width - boxWidth) / 2;
        int boxY = (this.height - boxHeight) / 2;
        int maxVisibleLines = (boxHeight - 10) / 10;
        List<LogCache.LogEntry> logEntries = LogCache.getLogs();
        List<RenderedLine> renderedLines = logEntries.stream().map(entry -> new RenderedLine(entry.message(), entry.color())).toList();
        if (renderedLines.size() <= maxVisibleLines) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        int scrollbarXStart = boxX + boxWidth - 6;
        int scrollbarXEnd = boxX + boxWidth - 3;
        int scrollbarHeight = (int)((float)maxVisibleLines / (float)renderedLines.size() * (float)(boxHeight - 10));
        int scrollbarYStart = boxY + 5 + (int)((float)this.scrollOffset / (float)renderedLines.size() * (float)(boxHeight - 10));
        int scrollbarYEnd = scrollbarYStart + scrollbarHeight;
        if (!(pMouseX >= (double)scrollbarXStart && pMouseX <= (double)scrollbarXEnd && pMouseY >= (double)scrollbarYStart && pMouseY <= (double)scrollbarYEnd)) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        this.isDragging = true;
        this.dragStartY = (int)pMouseY;
        this.initialScrollOffset = this.scrollOffset;
        return true;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.isDragging) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        int boxHeight = (int)((double)this.height * 0.9);
        List<LogCache.LogEntry> logEntries = LogCache.getLogs();
        ArrayList<RenderedLine> renderedLines = new ArrayList<RenderedLine>();
        for (LogCache.LogEntry entry : logEntries) {
            renderedLines.add(new RenderedLine(entry.message(), entry.color()));
        }
        int maxVisibleLines = (boxHeight - 10) / 10;
        int maxOffset = Math.max(0, renderedLines.size() - maxVisibleLines);
        int deltaY = (int)pMouseY - this.dragStartY;
        int scrollableHeight = boxHeight - 10;
        this.scrollOffset = this.initialScrollOffset + (int)((float)deltaY / (float)scrollableHeight * (float)renderedLines.size());
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxOffset));
        return true;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY > 0.0) {
            this.scrollOffset = Math.max(0, this.scrollOffset - 1);
        } else if (pScrollY < 0.0) {
            ++this.scrollOffset;
        }
        return true;
    }

    private record RenderedLine(@NotNull String text, @NotNull Integer color) {
    }
}

