/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.net.loader;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.ClientNetworkPacketHandler;
import software.bluelib.client.utils.LevelUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.entity.BlueEntity;
import software.bluelib.loader.animatable.entity.BlueReplacedEntity;
import software.bluelib.net.messages.client.loader.EntityAnimTriggerPacket;

public class EntityAnimTriggerPacketHandler
implements ClientNetworkPacketHandler<EntityAnimTriggerPacket> {
    @Override
    public void handle(@NotNull EntityAnimTriggerPacket pPacket, @NotNull Minecraft pClient) {
        String controllerName;
        if (LevelUtils.getLevel() == null) {
            return;
        }
        Entity entity = LevelUtils.getLevel().getEntity(pPacket.entityId().intValue());
        if (entity == null) {
            return;
        }
        String string = controllerName = pPacket.controllerName().isEmpty() ? null : pPacket.controllerName();
        if (!pPacket.isReplacedEntity()) {
            if (entity instanceof BlueEntity) {
                BlueEntity BlueEntity2 = (BlueEntity)entity;
                BlueEntity2.triggerAnim(controllerName, pPacket.animName());
            }
            return;
        }
        BlueAnimatable blueAnimatable = RenderUtils.getReplacedAnimatable(entity.getType());
        if (blueAnimatable instanceof BlueReplacedEntity) {
            BlueReplacedEntity replacedEntity = (BlueReplacedEntity)blueAnimatable;
            replacedEntity.triggerAnim(entity, controllerName, pPacket.animName());
        }
    }
}

