/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerUtils {
    @Nullable
    public static Player getOptionalClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @NotNull
    public static Player getClientPlayer() {
        Player player = PlayerUtils.getOptionalClientPlayer();
        if (player == null) {
            throw new IllegalStateException("Client player is not available, You are probably not in a World or the game is not running.");
        }
        return player;
    }

    @Nullable
    public static LocalPlayer getOptionalLocalPlayer() {
        return Minecraft.getInstance().player;
    }

    @NotNull
    public static LocalPlayer getLocalPlayer() {
        LocalPlayer player = PlayerUtils.getOptionalLocalPlayer();
        if (player == null) {
            throw new IllegalStateException("Local player is not available, You are probably not in a World or the game is not running.");
        }
        return player;
    }

    public static boolean isPlayerInCreativeMode() {
        Player player = PlayerUtils.getClientPlayer();
        return player.isCreative();
    }

    public static boolean isPlayerSneaking() {
        Player player = PlayerUtils.getClientPlayer();
        return player.isCrouching();
    }

    public static boolean isPlayerFlying() {
        Player player = PlayerUtils.getClientPlayer();
        return player.getAbilities().flying;
    }
}

