/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.block;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.registry.LoaderNetwork;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public interface BlueBlockEntity
extends BlueAnimatable {
    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(@NotNull SerializableDataTicket<D> pDataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(pDataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(@NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            BaseLogger.log(BaseLogLevel.ERROR, "Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + String.valueOf(blockEntity.getClass()) + ")");
            return;
        }
        if (level.isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(pDataTicket, pData);
        } else {
            LoaderNetwork.syncBlockEntityAnimData(blockEntity.getBlockPos(), pDataTicket, pData, (ServerLevel)level);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String pControllerName, @NotNull String pAnimName) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            BaseLogger.log(BaseLogLevel.ERROR, "Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + String.valueOf(blockEntity.getClass()) + ")");
            return;
        }
        if (level.isClientSide()) {
            if (pControllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(pControllerName, pAnimName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.triggerBlockEntityAnim(blockEntity.getBlockPos(), pControllerName, pAnimName, (ServerLevel)level);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@Nullable String pControllerName, @Nullable String pAnimName) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            BaseLogger.log(BaseLogLevel.ERROR, "Attempting to stop a triggered animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + String.valueOf(blockEntity.getClass()) + ")");
            return;
        }
        if (level.isClientSide()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(0L);
            if (pControllerName != null) {
                animatableManager.stopTriggeredAnimation(pControllerName, pAnimName);
            } else {
                animatableManager.stopTriggeredAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.stopTriggeredBlockEntityAnim(blockEntity.getBlockPos(), (ServerLevel)level, pControllerName, pAnimName);
        }
    }

    @Override
    @NotNull
    default public Double getTick(@NotNull Object pBlockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

