/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.cache;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.base.SingletonBlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;
import software.bluelib.loader.renderer.client.BlueRenderProvider;

public abstract class AnimatableInstanceCache<T extends BlueAnimatable> {
    @NotNull
    protected final BlueAnimatable animatable;
    @Nullable
    protected final Supplier<BlueRenderProvider> renderProvider;

    public AnimatableInstanceCache(@NotNull BlueAnimatable pAnimatable) {
        this.animatable = pAnimatable;
        this.renderProvider = Suppliers.memoize(() -> {
            SingletonBlueAnimatable singleton;
            block3: {
                block2: {
                    BlueAnimatable patt0$temp = this.animatable;
                    if (!(patt0$temp instanceof SingletonBlueAnimatable)) break block2;
                    singleton = (SingletonBlueAnimatable)patt0$temp;
                    if (BlueLibConstants.PlatformHelper.PLATFORM.isPhysicalClient()) break block3;
                }
                return null;
            }
            MutableObject consumer = new MutableObject((Object)BlueRenderProvider.DEFAULT);
            singleton.createBlueRenderer(arg_0 -> ((MutableObject)consumer).setValue(arg_0));
            return (BlueRenderProvider)consumer.getValue();
        });
    }

    @NotNull
    public abstract <M extends BlueAnimatable> AnimatableManager<M> getManagerForId(long var1);

    public <D> void addDataPoint(long pUniqueId, @NotNull DataTicket<D> pDataTicket, @NotNull D pData) {
        this.getManagerForId(pUniqueId).setData(pDataTicket, pData);
    }

    @Nullable
    public <D> D getDataPoint(long pUniqueId, @NotNull DataTicket<D> pDataTicket) {
        return this.getManagerForId(pUniqueId).getData(pDataTicket);
    }

    @Nullable
    public Object getRenderProvider() {
        if (this.renderProvider == null) {
            return null;
        }
        return this.renderProvider.get();
    }
}

