/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.entity;

import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.registry.LoaderNetwork;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.SingletonBlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;
import software.bluelib.loader.renderer.client.BlueRenderProvider;

public interface BlueReplacedEntity
extends SingletonBlueAnimatable {
    @NotNull
    public EntityType<?> getReplacingEntityType();

    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(@NotNull Entity pEntity, @NotNull SerializableDataTicket<D> pDataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(pEntity.getId()).getData(pDataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(@NotNull Entity pRelatedEntity, @NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData) {
        if (pRelatedEntity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.getId()).setData(pDataTicket, pData);
        } else {
            LoaderNetwork.syncEntityAnimData(pRelatedEntity, true, pDataTicket, pData);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@NotNull Entity pRelatedEntity, @Nullable String pControllerName, @NotNull String pAnimName) {
        if (pRelatedEntity.level().isClientSide()) {
            if (pControllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.getId()).tryTriggerAnimation(pControllerName, pAnimName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.getId()).tryTriggerAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.triggerEntityAnim(pRelatedEntity, true, pControllerName, pAnimName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@NotNull Entity pRelatedEntity, @Nullable String pControllerName, @Nullable String pAnimName) {
        if (pRelatedEntity.level().isClientSide()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.getId());
            if (pControllerName != null) {
                animatableManager.stopTriggeredAnimation(pControllerName, pAnimName);
            } else {
                animatableManager.stopTriggeredAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.stopTriggeredEntityAnim(pRelatedEntity, true, pControllerName, pAnimName);
        }
    }

    @Override
    @NotNull
    default public Double getTick(@NotNull Object pEntity) {
        return ((Entity)pEntity).tickCount;
    }

    @Override
    @ApiStatus.NonExtendable
    default public void createBlueRenderer(@NotNull Consumer<BlueRenderProvider> pConsumer) {
    }

    @Override
    @ApiStatus.NonExtendable
    @Nullable
    default public Object getRenderProvider() {
        return null;
    }
}

