/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.item;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.internal.registry.BlueDataComponentRegistry;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.base.ContextAwareAnimatableManager;
import software.bluelib.loader.animatable.base.SingletonBlueAnimatable;
import software.bluelib.loader.animatable.cache.AnimatableInstanceCache;
import software.bluelib.loader.animatable.cache.SingletonAnimatableInstanceCache;
import software.bluelib.loader.cache.item.IdCache;
import software.bluelib.loader.geckolib.constant.DataTickets;

public interface BlueItem
extends SingletonBlueAnimatable {
    public static void registerSyncedAnimatable(@NotNull BlueAnimatable pAnimatable) {
        SingletonBlueAnimatable.registerSyncedAnimatable(pAnimatable);
    }

    public static long getId(@NotNull ItemStack pStack) {
        return Optional.ofNullable(pStack.getComponentsPatch().get(BlueDataComponentRegistry.STACK_ANIMATABLE_ID.get())).filter(Optional::isPresent).map(Optional::get).orElse(Long.MAX_VALUE);
    }

    public static long getOrAssignId(@NotNull ItemStack pStack, @NotNull ServerLevel pLevel) {
        DataComponentMap dataComponentMap = pStack.getComponents();
        if (!(dataComponentMap instanceof PatchedDataComponentMap)) {
            return Long.MAX_VALUE;
        }
        PatchedDataComponentMap components = (PatchedDataComponentMap)dataComponentMap;
        Long id = (Long)components.get(BlueDataComponentRegistry.STACK_ANIMATABLE_ID.get());
        if (id == null) {
            id = IdCache.getFreeId(pLevel);
            components.set(BlueDataComponentRegistry.STACK_ANIMATABLE_ID.get(), (Object)id);
        }
        return id;
    }

    @Override
    @NotNull
    default public Double getTick(@NotNull Object pItemStack) {
        return RenderUtils.getCurrentTick();
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache<SingletonBlueAnimatable> useCustomCache() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache<SingletonBlueAnimatable>(this);
        }
        return SingletonBlueAnimatable.super.useCustomCache();
    }

    public static class ContextBasedAnimatableInstanceCache<T extends SingletonBlueAnimatable>
    extends SingletonAnimatableInstanceCache<T> {
        public ContextBasedAnimatableInstanceCache(@NotNull BlueAnimatable pAnimatable) {
            super(pAnimatable);
        }

        @Override
        @NotNull
        public <M extends BlueAnimatable> AnimatableManager<M> getManagerForId(long pUniqueId) {
            if (!this.managers.containsKey(pUniqueId)) {
                this.managers.put(pUniqueId, (Object)new ContextAwareAnimatableManager<BlueItem, ItemDisplayContext>(this, this.animatable){

                    @Override
                    @NotNull
                    protected Map<ItemDisplayContext, AnimatableManager<BlueItem>> buildContextOptions(@NotNull BlueAnimatable pAnimatable) {
                        EnumMap<ItemDisplayContext, AnimatableManager<BlueItem>> map = new EnumMap<ItemDisplayContext, AnimatableManager<BlueItem>>(ItemDisplayContext.class);
                        for (ItemDisplayContext context : ItemDisplayContext.values()) {
                            map.put(context, new AnimatableManager(pAnimatable));
                        }
                        return map;
                    }

                    @Override
                    @NotNull
                    public ItemDisplayContext getCurrentContext() {
                        ItemDisplayContext context = this.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemDisplayContext.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(pUniqueId);
        }
    }
}

