/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.entity.variant.IVariantProvider;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.BlueLoader;
import software.bluelib.loader.cache.animations.AnimationLibraryCache;
import software.bluelib.loader.cache.controller.ControllerCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.variants.EntityCache;
import software.bluelib.loader.geckolib.math.value.Constant;
import software.bluelib.loader.json.deserialize.animation.BakedAnimationsAdapter;

public class ResourceCache
extends BlueLoader {

    public static class Server {
        @NotNull
        public static Map<ResourceLocation, EntityCache> VARIANTS = Collections.emptyMap();
        @NotNull
        private static Map<ResourceLocation, ControllerCache> CONTROLLERS = Collections.emptyMap();

        @NotNull
        public static Map<ResourceLocation, EntityCache> getVariants() {
            return VARIANTS;
        }

        @NotNull
        public static Map<ResourceLocation, ControllerCache> getControllers() {
            return CONTROLLERS;
        }

        public static void registerReloadListener(@NotNull MinecraftServer pServer, @NotNull List<IVariantProvider> pProviders) {
            Server.reload(pProviders, pServer.getResourceManager(), Util.backgroundExecutor(), (Executor)pServer);
        }

        public static CompletableFuture<Void> reload(@NotNull List<IVariantProvider> pProviders, @NotNull ResourceManager pResourceManager, @NotNull Executor pBackgroundExecutor, @NotNull Executor pGameExecutor) {
            Server.clearCaches();
            CompletionStage controllers = ResourceCache.loadControllers(pBackgroundExecutor, pResourceManager).exceptionally(ex -> {
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, "controllers failed: " + ex.getMessage());
                return Collections.emptyMap();
            });
            CompletionStage variants = ResourceCache.loadVariants(pBackgroundExecutor, pResourceManager, pProviders).exceptionally(ex -> {
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, "variants failed: " + ex.getMessage());
                return Collections.emptyMap();
            });
            return ((CompletableFuture)controllers).thenCombineAsync(variants, (c, v) -> {
                CONTROLLERS = c;
                VARIANTS = v;
                System.out.println("Variants Cache: " + String.valueOf(VARIANTS));
                System.out.println("Controllers Cache: " + String.valueOf(CONTROLLERS));
                return null;
            }, pGameExecutor);
        }

        public static void clearCaches() {
            VARIANTS = Collections.emptyMap();
            CONTROLLERS = Collections.emptyMap();
        }
    }

    public static class Client {
        @NotNull
        private static Map<ResourceLocation, AnimationLibraryCache> ANIMATIONS = Collections.emptyMap();
        @NotNull
        private static Map<ResourceLocation, ModelCache> MODELS = Collections.emptyMap();

        @NotNull
        public static Map<ResourceLocation, AnimationLibraryCache> getBakedAnimations() {
            return ANIMATIONS;
        }

        @NotNull
        public static Map<ResourceLocation, ModelCache> getBakedModels() {
            return MODELS;
        }

        public static void registerReloadListener() {
            Minecraft mc = Minecraft.getInstance();
            ResourceManager resourceManager = mc.getResourceManager();
            if (resourceManager instanceof ReloadableResourceManager) {
                ReloadableResourceManager pResourceManager = (ReloadableResourceManager)resourceManager;
                pResourceManager.registerReloadListener(Client::reload);
            }
        }

        @NotNull
        public static CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier pStage, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfilerFiller, @NotNull ProfilerFiller pProfilerFiller1, @NotNull Executor pBackgroundExecutor, @NotNull Executor pGameExecutor) {
            Client.clearCaches();
            CompletableFuture animations = ResourceCache.loadAnimations(pBackgroundExecutor, pResourceManager);
            CompletableFuture models = ResourceCache.loadModels(pBackgroundExecutor, pResourceManager);
            return CompletableFuture.runAsync(() -> {
                BakedAnimationsAdapter.COMPRESSION_CACHE = new ConcurrentHashMap<Double, Constant>();
            }, pBackgroundExecutor).thenCompose(ignored -> ((CompletableFuture)CompletableFuture.allOf(animations, models).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)pStage).wait(arg_0))).thenRunAsync(() -> {
                ANIMATIONS = (Map)animations.join();
                MODELS = (Map)models.join();
                BakedAnimationsAdapter.COMPRESSION_CACHE = null;
                System.out.println("Model Cache: " + String.valueOf(MODELS));
                System.out.println("Animations Cache: " + String.valueOf(ANIMATIONS));
            }, pGameExecutor));
        }

        private static void clearCaches() {
            ANIMATIONS = Collections.emptyMap();
            MODELS = Collections.emptyMap();
        }
    }
}

