/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.controller;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;

public record AnimationCache(@NotNull List<String> conditions, @NotNull String animation, @Nullable Integer priority, @Nullable String sound) {
    @NotNull
    public static final Codec<AnimationCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)AnimationCache.readFromNBT(tag));
    }, animationCache -> {
        CompoundTag tag = new CompoundTag();
        animationCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<AnimationCache> ANIMATION_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        CompoundTagUtils.writeList(pTag, "conditions", this.conditions, (tag, data) -> tag.putString("condition", data));
        pTag.putString("animation", this.animation);
        if (this.priority != null) {
            pTag.putInt("priority", this.priority.intValue());
        }
        if (this.sound != null) {
            pTag.putString("sound", this.sound);
        }
    }

    @NotNull
    public static AnimationCache readFromNBT(@NotNull CompoundTag pTag) {
        List<String> conditions = CompoundTagUtils.readList(pTag, "conditions", tag -> tag.getString("condition"));
        String animation = pTag.getString("animation");
        Integer priority = pTag.contains("priority") ? Integer.valueOf(pTag.getInt("priority")) : null;
        String sound = pTag.contains("sound") ? pTag.getString("sound") : null;
        return new AnimationCache(conditions, animation, priority, sound);
    }
}

