/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.controller;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;
import software.bluelib.loader.cache.controller.StateCache;

public record BehaviourCache(@NotNull List<String> conditions, @Nullable Integer priority, @NotNull Map<String, StateCache> states) {
    @NotNull
    public static final Codec<BehaviourCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)BehaviourCache.readFromNBT(tag));
    }, behaviorCache -> {
        CompoundTag tag = new CompoundTag();
        behaviorCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<BehaviourCache> BEHAVIOUR_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        CompoundTagUtils.writeList(pTag, "conditions", this.conditions, (tag, data) -> tag.putString("condition", data));
        if (this.priority != null) {
            pTag.putInt("priority", this.priority.intValue());
        }
        CompoundTagUtils.writeMap(pTag, "states", this.states, (tag, key) -> tag.putString("name", key), (tag, value) -> value.writeToNBT((CompoundTag)tag), "name", "state");
    }

    @NotNull
    public static BehaviourCache readFromNBT(@NotNull CompoundTag pTag) {
        List<String> conditions = CompoundTagUtils.readList(pTag, "conditions", tag -> tag.getString("condition"));
        Integer priority = pTag.contains("priority") ? Integer.valueOf(pTag.getInt("priority")) : null;
        Map<String, StateCache> states = CompoundTagUtils.readMap(pTag, "states", tag -> tag.getString("name"), StateCache::readFromNBT, "name", "state");
        return new BehaviourCache(conditions, priority, states);
    }

    @Nullable
    public StateCache getState(@NotNull String pName) {
        StateCache state = this.states.get(pName);
        if (state == null) {
            BaseLogger.log(BaseLogLevel.WARNING, "State not found: " + pName);
        }
        return state;
    }

    @NotNull
    public StateCache getMainState() {
        return this.states.values().iterator().next();
    }
}

