/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.controller;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;
import software.bluelib.loader.cache.controller.BehaviourCache;

public record GroupCache(@NotNull Map<String, BehaviourCache> behaviours) {
    @NotNull
    public static final Codec<GroupCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)GroupCache.readFromNBT(tag));
    }, groupCache -> {
        CompoundTag tag = new CompoundTag();
        groupCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<GroupCache> GROUP_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        CompoundTagUtils.writeMap(pTag, "behaviours", this.behaviours, (tag, key) -> tag.putString("name", key), (tag, value) -> value.writeToNBT((CompoundTag)tag), "name", "behaviour");
    }

    @NotNull
    public static GroupCache readFromNBT(@NotNull CompoundTag pTag) {
        Map<String, BehaviourCache> behaviours = CompoundTagUtils.readMap(pTag, "behaviours", tag -> tag.getString("name"), BehaviourCache::readFromNBT, "name", "behaviour");
        return new GroupCache(behaviours);
    }

    @NotNull
    public BehaviourCache getBehaviour(@NotNull String pName) {
        return this.behaviours.get(pName);
    }
}

