/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.variants;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;

public record VariantCache(@Nullable JsonArray parameters) {
    @NotNull
    public static final Codec<VariantCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)VariantCache.readFromNBT(tag));
    }, variantsCache -> {
        CompoundTag tag = new CompoundTag();
        variantsCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<VariantCache> VARIANT_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        CompoundTagUtils.writeJsonArray(pTag, "parameters", this.parameters);
    }

    @NotNull
    public static VariantCache readFromNBT(@NotNull CompoundTag pTag) {
        return new VariantCache(CompoundTagUtils.readJsonArray(pTag, "parameters"));
    }

    @Nullable
    public JsonElement getParameter(@NotNull String pParameterName) {
        if (this.parameters == null) {
            return null;
        }
        for (JsonElement element : this.parameters) {
            if (!element.isJsonObject() || !element.getAsJsonObject().has(pParameterName)) continue;
            return element.getAsJsonObject().get(pParameterName);
        }
        return null;
    }
}

