/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math.function.generic;

import software.bluelib.loader.geckolib.math.MathValue;
import software.bluelib.loader.geckolib.math.function.MathFunction;

public final class PowFunction
extends MathFunction {
    private final MathValue value;
    private final MathValue power;

    public PowFunction(MathValue ... values) {
        super(values);
        this.value = values[0];
        this.power = values[1];
    }

    @Override
    public String getName() {
        return "math.pow";
    }

    @Override
    public double compute() {
        return Math.pow(this.value.get(), this.power.get());
    }

    @Override
    public int getMinArgs() {
        return 2;
    }

    @Override
    public MathValue[] getArgs() {
        return new MathValue[]{this.value, this.power};
    }
}

