/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math.function.random;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.geckolib.math.MathValue;
import software.bluelib.loader.geckolib.math.function.MathFunction;

public final class DieRollIntegerFunction
extends MathFunction {
    private final MathValue rolls;
    private final MathValue min;
    private final MathValue max;
    @Nullable
    private final MathValue seed;
    @Nullable
    private final Random random;

    public DieRollIntegerFunction(MathValue ... values) {
        super(values);
        this.rolls = values[0];
        this.min = values[1];
        this.max = values[2];
        this.seed = values.length >= 4 ? values[3] : null;
        this.random = this.seed != null ? new Random() : null;
    }

    @Override
    public String getName() {
        return "math.die_roll";
    }

    @Override
    public double compute() {
        Random random;
        int rolls = (int)Math.floor(this.rolls.get());
        int min = Mth.floor((double)this.min.get());
        int max = Mth.ceil((double)this.max.get());
        int sum = 0;
        if (this.random != null) {
            random = this.random;
            random.setSeed((long)this.seed.get());
        } else {
            random = ThreadLocalRandom.current();
        }
        for (int i = 0; i < rolls; ++i) {
            sum += min + random.nextInt(max + 1 - min);
        }
        return sum;
    }

    @Override
    public boolean isMutable(MathValue ... values) {
        if (values.length < 4) {
            return true;
        }
        return super.isMutable(values);
    }

    @Override
    public int getMinArgs() {
        return 3;
    }

    @Override
    public MathValue[] getArgs() {
        if (this.seed != null) {
            return new MathValue[]{this.rolls, this.min, this.max, this.seed};
        }
        return new MathValue[]{this.rolls, this.min, this.max};
    }
}

