/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math.function.random;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.geckolib.math.MathValue;
import software.bluelib.loader.geckolib.math.function.MathFunction;

public final class RandomIntegerFunction
extends MathFunction {
    private final MathValue valueA;
    @Nullable
    private final MathValue valueB;
    @Nullable
    private final MathValue seed;
    @Nullable
    private final Random random;

    public RandomIntegerFunction(MathValue ... values) {
        super(values);
        this.valueA = values[0];
        this.valueB = values.length >= 2 ? values[1] : null;
        this.seed = values.length >= 3 ? values[2] : null;
        this.random = this.seed != null ? new Random() : null;
    }

    @Override
    public String getName() {
        return "math.random_integer";
    }

    @Override
    public double compute() {
        int result;
        Random random;
        int valueA = (int)Math.round(this.valueA.get());
        if (this.random != null) {
            this.random.setSeed((long)this.seed.get());
            random = this.random;
        } else {
            random = ThreadLocalRandom.current();
        }
        if (this.valueB != null) {
            int valueB = (int)Math.round(this.valueB.get());
            int min = Math.min(valueA, valueB);
            int max = Math.max(valueA, valueB);
            result = min + random.nextInt(max + 1 - min);
        } else {
            result = random.nextInt(0, valueA + 1);
        }
        return result;
    }

    @Override
    public boolean isMutable(MathValue ... values) {
        if (values.length < 3) {
            return true;
        }
        return super.isMutable(values);
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public MathValue[] getArgs() {
        if (this.seed != null) {
            return new MathValue[]{this.valueA, this.valueB, this.seed};
        }
        if (this.valueB != null) {
            return new MathValue[]{this.valueA, this.valueB};
        }
        return new MathValue[]{this.valueA};
    }
}

