/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math.value;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleSupplier;
import software.bluelib.loader.geckolib.math.MathValue;

public record Variable(String name, AtomicReference<DoubleSupplier> value) implements MathValue
{
    public Variable(String name, double value) {
        this(name, () -> value);
    }

    public Variable(String name, DoubleSupplier value) {
        this(name, new AtomicReference<DoubleSupplier>(value));
    }

    @Override
    public double get() {
        try {
            return this.value.get().getAsDouble();
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public void set(double value) {
        this.value.set(() -> value);
    }

    public void set(DoubleSupplier value) {
        this.value.set(value);
    }

    @Override
    public String toString() {
        return this.name + "(" + this.value.get().getAsDouble() + ")";
    }
}

